/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.oce.OceInstance;
import com.oracle.bmc.oce.OceInstanceAsyncClient;
import com.oracle.bmc.oce.OceInstancePaginators;
import com.oracle.bmc.oce.OceInstanceWaiters;
import com.oracle.bmc.oce.model.OceInstanceSummary;
import com.oracle.bmc.oce.model.WorkRequest;
import com.oracle.bmc.oce.model.WorkRequestError;
import com.oracle.bmc.oce.model.WorkRequestLogEntry;
import com.oracle.bmc.oce.requests.ChangeOceInstanceCompartmentRequest;
import com.oracle.bmc.oce.requests.CreateOceInstanceRequest;
import com.oracle.bmc.oce.requests.DeleteOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.requests.UpdateOceInstanceRequest;
import com.oracle.bmc.oce.responses.ChangeOceInstanceCompartmentResponse;
import com.oracle.bmc.oce.responses.CreateOceInstanceResponse;
import com.oracle.bmc.oce.responses.DeleteOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oce.responses.UpdateOceInstanceResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceInstanceClient
extends BaseSyncClient
implements OceInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCEINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp.oce.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OceInstanceAsyncClient.class);
    private final OceInstanceWaiters waiters;
    private final OceInstancePaginators paginators;

    private OceInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OceInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OceInstanceWaiters(executorService, this);
        this.paginators = new OceInstancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeOceInstanceCompartmentResponse changeOceInstanceCompartment(ChangeOceInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOceInstanceCompartmentDetails(), "changeOceInstanceCompartmentDetails is required");
        return (ChangeOceInstanceCompartmentResponse)this.clientCall(request, ChangeOceInstanceCompartmentResponse::builder).logger(LOG, "changeOceInstanceCompartment").serviceDetails("OceInstance", "ChangeOceInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/ChangeOceInstanceCompartment").method(Method.POST).requestBuilder(ChangeOceInstanceCompartmentRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOceInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOceInstanceCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateOceInstanceResponse createOceInstance(CreateOceInstanceRequest request) {
        Objects.requireNonNull(request.getCreateOceInstanceDetails(), "createOceInstanceDetails is required");
        return (CreateOceInstanceResponse)this.clientCall(request, CreateOceInstanceResponse::builder).logger(LOG, "createOceInstance").serviceDetails("OceInstance", "CreateOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/CreateOceInstance").method(Method.POST).requestBuilder(CreateOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOceInstanceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteOceInstanceResponse deleteOceInstance(DeleteOceInstanceRequest request) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteOceInstanceResponse)this.clientCall(request, DeleteOceInstanceResponse::builder).logger(LOG, "deleteOceInstance").serviceDetails("OceInstance", "DeleteOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/DeleteOceInstance").method(Method.DELETE).requestBuilder(DeleteOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOceInstanceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetOceInstanceResponse getOceInstance(GetOceInstanceRequest request) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        return (GetOceInstanceResponse)this.clientCall(request, GetOceInstanceResponse::builder).logger(LOG, "getOceInstance").serviceDetails("OceInstance", "GetOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/GetOceInstance").method(Method.GET).requestBuilder(GetOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.oce.model.OceInstance.class, GetOceInstanceResponse.Builder::oceInstance).handleResponseHeaderString("etag", GetOceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOceInstanceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OceInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListOceInstancesResponse listOceInstances(ListOceInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOceInstancesResponse)this.clientCall(request, ListOceInstancesResponse::builder).logger(LOG, "listOceInstances").serviceDetails("OceInstance", "ListOceInstances", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstanceSummary/ListOceInstances").method(Method.GET).requestBuilder(ListOceInstancesRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(OceInstanceSummary.class, ListOceInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListOceInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOceInstancesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OceInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OceInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OceInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateOceInstanceResponse updateOceInstance(UpdateOceInstanceRequest request) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOceInstanceDetails(), "updateOceInstanceDetails is required");
        return (UpdateOceInstanceResponse)this.clientCall(request, UpdateOceInstanceResponse::builder).logger(LOG, "updateOceInstance").serviceDetails("OceInstance", "UpdateOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/UpdateOceInstance").method(Method.PUT).requestBuilder(UpdateOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOceInstanceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public OceInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OceInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OceInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OceInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OceInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OceInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OceInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OceInstanceClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

