/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetRowRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private List<String> key;
    private String compartmentId;
    private Consistency consistency;
    private Integer timeoutInMs;
    private String opcRequestId;

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public List<String> getKey() {
        return this.key;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tableNameOrId(this.tableNameOrId).key(this.key).compartmentId(this.compartmentId).consistency(this.consistency).timeoutInMs(this.timeoutInMs).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tableNameOrId=").append(String.valueOf(this.tableNameOrId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",consistency=").append(String.valueOf((Object)this.consistency));
        sb.append(",timeoutInMs=").append(String.valueOf(this.timeoutInMs));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRowRequest)) {
            return false;
        }
        GetRowRequest other = (GetRowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tableNameOrId, other.tableNameOrId) && Objects.equals(this.key, other.key) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.consistency, (Object)other.consistency) && Objects.equals(this.timeoutInMs, other.timeoutInMs) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tableNameOrId == null ? 43 : this.tableNameOrId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.consistency == null ? 43 : this.consistency.hashCode());
        result = result * 59 + (this.timeoutInMs == null ? 43 : this.timeoutInMs.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRowRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tableNameOrId = null;
        private List<String> key = null;
        private String compartmentId = null;
        private Consistency consistency = null;
        private Integer timeoutInMs = null;
        private String opcRequestId = null;

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder key(List<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String singularValue) {
            return this.key(Arrays.asList(singularValue));
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder consistency(Consistency consistency) {
            this.consistency = consistency;
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRowRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.key(o.getKey());
            this.compartmentId(o.getCompartmentId());
            this.consistency(o.getConsistency());
            this.timeoutInMs(o.getTimeoutInMs());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRowRequest build() {
            GetRowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRowRequest buildWithoutInvocationCallback() {
            GetRowRequest request = new GetRowRequest();
            request.tableNameOrId = this.tableNameOrId;
            request.key = this.key;
            request.compartmentId = this.compartmentId;
            request.consistency = this.consistency;
            request.timeoutInMs = this.timeoutInMs;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Consistency implements BmcEnum
    {
        Eventual("EVENTUAL"),
        Absolute("ABSOLUTE");

        private final String value;
        private static Map<String, Consistency> map;

        private Consistency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Consistency create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Consistency: " + key);
        }

        static {
            map = new HashMap<String, Consistency>();
            for (Consistency v : Consistency.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

