/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DeleteRowRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private List<String> key;
    private String compartmentId;
    private Boolean isGetReturnRow;
    private Integer timeoutInMs;
    private String ifMatch;
    private String opcRequestId;

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public List<String> getKey() {
        return this.key;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsGetReturnRow() {
        return this.isGetReturnRow;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tableNameOrId(this.tableNameOrId).key(this.key).compartmentId(this.compartmentId).isGetReturnRow(this.isGetReturnRow).timeoutInMs(this.timeoutInMs).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tableNameOrId=").append(String.valueOf(this.tableNameOrId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",isGetReturnRow=").append(String.valueOf(this.isGetReturnRow));
        sb.append(",timeoutInMs=").append(String.valueOf(this.timeoutInMs));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteRowRequest)) {
            return false;
        }
        DeleteRowRequest other = (DeleteRowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tableNameOrId, other.tableNameOrId) && Objects.equals(this.key, other.key) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isGetReturnRow, other.isGetReturnRow) && Objects.equals(this.timeoutInMs, other.timeoutInMs) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tableNameOrId == null ? 43 : this.tableNameOrId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isGetReturnRow == null ? 43 : this.isGetReturnRow.hashCode());
        result = result * 59 + (this.timeoutInMs == null ? 43 : this.timeoutInMs.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteRowRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tableNameOrId = null;
        private List<String> key = null;
        private String compartmentId = null;
        private Boolean isGetReturnRow = null;
        private Integer timeoutInMs = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder key(List<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String singularValue) {
            return this.key(Arrays.asList(singularValue));
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder isGetReturnRow(Boolean isGetReturnRow) {
            this.isGetReturnRow = isGetReturnRow;
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRowRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.key(o.getKey());
            this.compartmentId(o.getCompartmentId());
            this.isGetReturnRow(o.getIsGetReturnRow());
            this.timeoutInMs(o.getTimeoutInMs());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRowRequest build() {
            DeleteRowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteRowRequest buildWithoutInvocationCallback() {
            DeleteRowRequest request = new DeleteRowRequest();
            request.tableNameOrId = this.tableNameOrId;
            request.key = this.key;
            request.compartmentId = this.compartmentId;
            request.isGetReturnRow = this.isGetReturnRow;
            request.timeoutInMs = this.timeoutInMs;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

