/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateRowDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="value")
    private final Map<String, Object> value;
    @JsonProperty(value="option")
    private final Option option;
    @JsonProperty(value="isGetReturnRow")
    private final Boolean isGetReturnRow;
    @JsonProperty(value="timeoutInMs")
    private final Integer timeoutInMs;
    @JsonProperty(value="ttl")
    private final Integer ttl;
    @JsonProperty(value="isTtlUseTableDefault")
    private final Boolean isTtlUseTableDefault;
    @JsonProperty(value="identityCacheSize")
    private final Integer identityCacheSize;
    @JsonProperty(value="isExactMatch")
    private final Boolean isExactMatch;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "value", "option", "isGetReturnRow", "timeoutInMs", "ttl", "isTtlUseTableDefault", "identityCacheSize", "isExactMatch"})
    public UpdateRowDetails(String compartmentId, Map<String, Object> value, Option option, Boolean isGetReturnRow, Integer timeoutInMs, Integer ttl, Boolean isTtlUseTableDefault, Integer identityCacheSize, Boolean isExactMatch) {
        this.compartmentId = compartmentId;
        this.value = value;
        this.option = option;
        this.isGetReturnRow = isGetReturnRow;
        this.timeoutInMs = timeoutInMs;
        this.ttl = ttl;
        this.isTtlUseTableDefault = isTtlUseTableDefault;
        this.identityCacheSize = identityCacheSize;
        this.isExactMatch = isExactMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public Option getOption() {
        return this.option;
    }

    public Boolean getIsGetReturnRow() {
        return this.isGetReturnRow;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Boolean getIsTtlUseTableDefault() {
        return this.isTtlUseTableDefault;
    }

    public Integer getIdentityCacheSize() {
        return this.identityCacheSize;
    }

    public Boolean getIsExactMatch() {
        return this.isExactMatch;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateRowDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", option=").append(String.valueOf((Object)this.option));
        sb.append(", isGetReturnRow=").append(String.valueOf(this.isGetReturnRow));
        sb.append(", timeoutInMs=").append(String.valueOf(this.timeoutInMs));
        sb.append(", ttl=").append(String.valueOf(this.ttl));
        sb.append(", isTtlUseTableDefault=").append(String.valueOf(this.isTtlUseTableDefault));
        sb.append(", identityCacheSize=").append(String.valueOf(this.identityCacheSize));
        sb.append(", isExactMatch=").append(String.valueOf(this.isExactMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRowDetails)) {
            return false;
        }
        UpdateRowDetails other = (UpdateRowDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.option, (Object)other.option) && Objects.equals(this.isGetReturnRow, other.isGetReturnRow) && Objects.equals(this.timeoutInMs, other.timeoutInMs) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.isTtlUseTableDefault, other.isTtlUseTableDefault) && Objects.equals(this.identityCacheSize, other.identityCacheSize) && Objects.equals(this.isExactMatch, other.isExactMatch) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.option == null ? 43 : this.option.hashCode());
        result = result * 59 + (this.isGetReturnRow == null ? 43 : this.isGetReturnRow.hashCode());
        result = result * 59 + (this.timeoutInMs == null ? 43 : this.timeoutInMs.hashCode());
        result = result * 59 + (this.ttl == null ? 43 : this.ttl.hashCode());
        result = result * 59 + (this.isTtlUseTableDefault == null ? 43 : this.isTtlUseTableDefault.hashCode());
        result = result * 59 + (this.identityCacheSize == null ? 43 : this.identityCacheSize.hashCode());
        result = result * 59 + (this.isExactMatch == null ? 43 : this.isExactMatch.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Option implements BmcEnum
    {
        IfAbsent("IF_ABSENT"),
        IfPresent("IF_PRESENT");

        private final String value;
        private static Map<String, Option> map;

        private Option(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Option create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Option: " + key);
        }

        static {
            map = new HashMap<String, Option>();
            for (Option v : Option.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="value")
        private Map<String, Object> value;
        @JsonProperty(value="option")
        private Option option;
        @JsonProperty(value="isGetReturnRow")
        private Boolean isGetReturnRow;
        @JsonProperty(value="timeoutInMs")
        private Integer timeoutInMs;
        @JsonProperty(value="ttl")
        private Integer ttl;
        @JsonProperty(value="isTtlUseTableDefault")
        private Boolean isTtlUseTableDefault;
        @JsonProperty(value="identityCacheSize")
        private Integer identityCacheSize;
        @JsonProperty(value="isExactMatch")
        private Boolean isExactMatch;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder value(Map<String, Object> value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder option(Option option) {
            this.option = option;
            this.__explicitlySet__.add("option");
            return this;
        }

        public Builder isGetReturnRow(Boolean isGetReturnRow) {
            this.isGetReturnRow = isGetReturnRow;
            this.__explicitlySet__.add("isGetReturnRow");
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            this.__explicitlySet__.add("timeoutInMs");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.__explicitlySet__.add("ttl");
            return this;
        }

        public Builder isTtlUseTableDefault(Boolean isTtlUseTableDefault) {
            this.isTtlUseTableDefault = isTtlUseTableDefault;
            this.__explicitlySet__.add("isTtlUseTableDefault");
            return this;
        }

        public Builder identityCacheSize(Integer identityCacheSize) {
            this.identityCacheSize = identityCacheSize;
            this.__explicitlySet__.add("identityCacheSize");
            return this;
        }

        public Builder isExactMatch(Boolean isExactMatch) {
            this.isExactMatch = isExactMatch;
            this.__explicitlySet__.add("isExactMatch");
            return this;
        }

        public UpdateRowDetails build() {
            UpdateRowDetails model = new UpdateRowDetails(this.compartmentId, this.value, this.option, this.isGetReturnRow, this.timeoutInMs, this.ttl, this.isTtlUseTableDefault, this.identityCacheSize, this.isExactMatch);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateRowDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("option")) {
                this.option(model.getOption());
            }
            if (model.wasPropertyExplicitlySet("isGetReturnRow")) {
                this.isGetReturnRow(model.getIsGetReturnRow());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMs")) {
                this.timeoutInMs(model.getTimeoutInMs());
            }
            if (model.wasPropertyExplicitlySet("ttl")) {
                this.ttl(model.getTtl());
            }
            if (model.wasPropertyExplicitlySet("isTtlUseTableDefault")) {
                this.isTtlUseTableDefault(model.getIsTtlUseTableDefault());
            }
            if (model.wasPropertyExplicitlySet("identityCacheSize")) {
                this.identityCacheSize(model.getIdentityCacheSize());
            }
            if (model.wasPropertyExplicitlySet("isExactMatch")) {
                this.isExactMatch(model.getIsExactMatch());
            }
            return this;
        }
    }
}

