/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.nosql.model.Column;
import com.oracle.bmc.nosql.model.Identity;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Schema
extends ExplicitlySetBmcModel {
    @JsonProperty(value="columns")
    private final List<Column> columns;
    @JsonProperty(value="primaryKey")
    private final List<String> primaryKey;
    @JsonProperty(value="shardKey")
    private final List<String> shardKey;
    @JsonProperty(value="ttl")
    private final Integer ttl;
    @JsonProperty(value="identity")
    private final Identity identity;

    @Deprecated
    @ConstructorProperties(value={"columns", "primaryKey", "shardKey", "ttl", "identity"})
    public Schema(List<Column> columns, List<String> primaryKey, List<String> shardKey, Integer ttl, Identity identity) {
        this.columns = columns;
        this.primaryKey = primaryKey;
        this.shardKey = shardKey;
        this.ttl = ttl;
        this.identity = identity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<String> getShardKey() {
        return this.shardKey;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Schema(");
        sb.append("super=").append(super.toString());
        sb.append("columns=").append(String.valueOf(this.columns));
        sb.append(", primaryKey=").append(String.valueOf(this.primaryKey));
        sb.append(", shardKey=").append(String.valueOf(this.shardKey));
        sb.append(", ttl=").append(String.valueOf(this.ttl));
        sb.append(", identity=").append(String.valueOf((Object)this.identity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)((Object)o);
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.primaryKey, other.primaryKey) && Objects.equals(this.shardKey, other.shardKey) && Objects.equals(this.ttl, other.ttl) && Objects.equals((Object)this.identity, (Object)other.identity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.primaryKey == null ? 43 : this.primaryKey.hashCode());
        result = result * 59 + (this.shardKey == null ? 43 : this.shardKey.hashCode());
        result = result * 59 + (this.ttl == null ? 43 : this.ttl.hashCode());
        result = result * 59 + (this.identity == null ? 43 : this.identity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="columns")
        private List<Column> columns;
        @JsonProperty(value="primaryKey")
        private List<String> primaryKey;
        @JsonProperty(value="shardKey")
        private List<String> shardKey;
        @JsonProperty(value="ttl")
        private Integer ttl;
        @JsonProperty(value="identity")
        private Identity identity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder primaryKey(List<String> primaryKey) {
            this.primaryKey = primaryKey;
            this.__explicitlySet__.add("primaryKey");
            return this;
        }

        public Builder shardKey(List<String> shardKey) {
            this.shardKey = shardKey;
            this.__explicitlySet__.add("shardKey");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.__explicitlySet__.add("ttl");
            return this;
        }

        public Builder identity(Identity identity) {
            this.identity = identity;
            this.__explicitlySet__.add("identity");
            return this;
        }

        public Schema build() {
            Schema model = new Schema(this.columns, this.primaryKey, this.shardKey, this.ttl, this.identity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Schema model) {
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("primaryKey")) {
                this.primaryKey(model.getPrimaryKey());
            }
            if (model.wasPropertyExplicitlySet("shardKey")) {
                this.shardKey(model.getShardKey());
            }
            if (model.wasPropertyExplicitlySet("ttl")) {
                this.ttl(model.getTtl());
            }
            if (model.wasPropertyExplicitlySet("identity")) {
                this.identity(model.getIdentity());
            }
            return this;
        }
    }
}

