/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="statement")
    private final String statement;
    @JsonProperty(value="isPrepared")
    private final Boolean isPrepared;
    @JsonProperty(value="consistency")
    private final Consistency consistency;
    @JsonProperty(value="maxReadInKBs")
    private final Integer maxReadInKBs;
    @JsonProperty(value="variables")
    private final Map<String, Object> variables;
    @JsonProperty(value="timeoutInMs")
    private final Integer timeoutInMs;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "statement", "isPrepared", "consistency", "maxReadInKBs", "variables", "timeoutInMs"})
    public QueryDetails(String compartmentId, String statement, Boolean isPrepared, Consistency consistency, Integer maxReadInKBs, Map<String, Object> variables, Integer timeoutInMs) {
        this.compartmentId = compartmentId;
        this.statement = statement;
        this.isPrepared = isPrepared;
        this.consistency = consistency;
        this.maxReadInKBs = maxReadInKBs;
        this.variables = variables;
        this.timeoutInMs = timeoutInMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStatement() {
        return this.statement;
    }

    public Boolean getIsPrepared() {
        return this.isPrepared;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public Integer getMaxReadInKBs() {
        return this.maxReadInKBs;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", statement=").append(String.valueOf(this.statement));
        sb.append(", isPrepared=").append(String.valueOf(this.isPrepared));
        sb.append(", consistency=").append(String.valueOf((Object)this.consistency));
        sb.append(", maxReadInKBs=").append(String.valueOf(this.maxReadInKBs));
        sb.append(", variables=").append(String.valueOf(this.variables));
        sb.append(", timeoutInMs=").append(String.valueOf(this.timeoutInMs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryDetails)) {
            return false;
        }
        QueryDetails other = (QueryDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.statement, other.statement) && Objects.equals(this.isPrepared, other.isPrepared) && Objects.equals((Object)this.consistency, (Object)other.consistency) && Objects.equals(this.maxReadInKBs, other.maxReadInKBs) && Objects.equals(this.variables, other.variables) && Objects.equals(this.timeoutInMs, other.timeoutInMs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.statement == null ? 43 : this.statement.hashCode());
        result = result * 59 + (this.isPrepared == null ? 43 : this.isPrepared.hashCode());
        result = result * 59 + (this.consistency == null ? 43 : this.consistency.hashCode());
        result = result * 59 + (this.maxReadInKBs == null ? 43 : this.maxReadInKBs.hashCode());
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        result = result * 59 + (this.timeoutInMs == null ? 43 : this.timeoutInMs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Consistency implements BmcEnum
    {
        Eventual("EVENTUAL"),
        Absolute("ABSOLUTE");

        private final String value;
        private static Map<String, Consistency> map;

        private Consistency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Consistency create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Consistency: " + key);
        }

        static {
            map = new HashMap<String, Consistency>();
            for (Consistency v : Consistency.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="statement")
        private String statement;
        @JsonProperty(value="isPrepared")
        private Boolean isPrepared;
        @JsonProperty(value="consistency")
        private Consistency consistency;
        @JsonProperty(value="maxReadInKBs")
        private Integer maxReadInKBs;
        @JsonProperty(value="variables")
        private Map<String, Object> variables;
        @JsonProperty(value="timeoutInMs")
        private Integer timeoutInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder statement(String statement) {
            this.statement = statement;
            this.__explicitlySet__.add("statement");
            return this;
        }

        public Builder isPrepared(Boolean isPrepared) {
            this.isPrepared = isPrepared;
            this.__explicitlySet__.add("isPrepared");
            return this;
        }

        public Builder consistency(Consistency consistency) {
            this.consistency = consistency;
            this.__explicitlySet__.add("consistency");
            return this;
        }

        public Builder maxReadInKBs(Integer maxReadInKBs) {
            this.maxReadInKBs = maxReadInKBs;
            this.__explicitlySet__.add("maxReadInKBs");
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            this.__explicitlySet__.add("timeoutInMs");
            return this;
        }

        public QueryDetails build() {
            QueryDetails model = new QueryDetails(this.compartmentId, this.statement, this.isPrepared, this.consistency, this.maxReadInKBs, this.variables, this.timeoutInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("statement")) {
                this.statement(model.getStatement());
            }
            if (model.wasPropertyExplicitlySet("isPrepared")) {
                this.isPrepared(model.getIsPrepared());
            }
            if (model.wasPropertyExplicitlySet("consistency")) {
                this.consistency(model.getConsistency());
            }
            if (model.wasPropertyExplicitlySet("maxReadInKBs")) {
                this.maxReadInKBs(model.getMaxReadInKBs());
            }
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMs")) {
                this.timeoutInMs(model.getTimeoutInMs());
            }
            return this;
        }
    }
}

