/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="isSupportedFor")
    private final List<IsSupportedFor> isSupportedFor;

    @Deprecated
    @ConstructorProperties(value={"name", "cpuCoreCount", "memorySizeInGBs", "isSupportedFor"})
    public ShapeSummary(String name, Integer cpuCoreCount, Integer memorySizeInGBs, List<IsSupportedFor> isSupportedFor) {
        this.name = name;
        this.cpuCoreCount = cpuCoreCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.isSupportedFor = isSupportedFor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public List<IsSupportedFor> getIsSupportedFor() {
        return this.isSupportedFor;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", isSupportedFor=").append(String.valueOf(this.isSupportedFor));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeSummary)) {
            return false;
        }
        ShapeSummary other = (ShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.isSupportedFor, other.isSupportedFor) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.isSupportedFor == null ? 43 : this.isSupportedFor.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IsSupportedFor implements BmcEnum
    {
        Dbsystem("DBSYSTEM"),
        Analyticscluster("ANALYTICSCLUSTER"),
        Heatwavecluster("HEATWAVECLUSTER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IsSupportedFor> map;

        private IsSupportedFor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSupportedFor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IsSupportedFor', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IsSupportedFor.class);
            map = new HashMap<String, IsSupportedFor>();
            for (IsSupportedFor v : IsSupportedFor.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="isSupportedFor")
        private List<IsSupportedFor> isSupportedFor;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder isSupportedFor(List<IsSupportedFor> isSupportedFor) {
            this.isSupportedFor = isSupportedFor;
            this.__explicitlySet__.add("isSupportedFor");
            return this;
        }

        public ShapeSummary build() {
            ShapeSummary model = new ShapeSummary(this.name, this.cpuCoreCount, this.memorySizeInGBs, this.isSupportedFor);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("isSupportedFor")) {
                this.isSupportedFor(model.getIsSupportedFor());
            }
            return this;
        }
    }
}

