/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnalyticsClusterTableMemoryEstimate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tableName")
    private final String tableName;
    @JsonProperty(value="toLoadColumnCount")
    private final Integer toLoadColumnCount;
    @JsonProperty(value="varlenColumnCount")
    private final Integer varlenColumnCount;
    @JsonProperty(value="estimatedRowCount")
    private final Long estimatedRowCount;
    @JsonProperty(value="analyticalFootprintInMbs")
    private final Long analyticalFootprintInMbs;
    @JsonProperty(value="errorComment")
    private final String errorComment;

    @Deprecated
    @ConstructorProperties(value={"tableName", "toLoadColumnCount", "varlenColumnCount", "estimatedRowCount", "analyticalFootprintInMbs", "errorComment"})
    public AnalyticsClusterTableMemoryEstimate(String tableName, Integer toLoadColumnCount, Integer varlenColumnCount, Long estimatedRowCount, Long analyticalFootprintInMbs, String errorComment) {
        this.tableName = tableName;
        this.toLoadColumnCount = toLoadColumnCount;
        this.varlenColumnCount = varlenColumnCount;
        this.estimatedRowCount = estimatedRowCount;
        this.analyticalFootprintInMbs = analyticalFootprintInMbs;
        this.errorComment = errorComment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getToLoadColumnCount() {
        return this.toLoadColumnCount;
    }

    public Integer getVarlenColumnCount() {
        return this.varlenColumnCount;
    }

    public Long getEstimatedRowCount() {
        return this.estimatedRowCount;
    }

    public Long getAnalyticalFootprintInMbs() {
        return this.analyticalFootprintInMbs;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalyticsClusterTableMemoryEstimate(");
        sb.append("super=").append(super.toString());
        sb.append("tableName=").append(String.valueOf(this.tableName));
        sb.append(", toLoadColumnCount=").append(String.valueOf(this.toLoadColumnCount));
        sb.append(", varlenColumnCount=").append(String.valueOf(this.varlenColumnCount));
        sb.append(", estimatedRowCount=").append(String.valueOf(this.estimatedRowCount));
        sb.append(", analyticalFootprintInMbs=").append(String.valueOf(this.analyticalFootprintInMbs));
        sb.append(", errorComment=").append(String.valueOf(this.errorComment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyticsClusterTableMemoryEstimate)) {
            return false;
        }
        AnalyticsClusterTableMemoryEstimate other = (AnalyticsClusterTableMemoryEstimate)((Object)o);
        return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.toLoadColumnCount, other.toLoadColumnCount) && Objects.equals(this.varlenColumnCount, other.varlenColumnCount) && Objects.equals(this.estimatedRowCount, other.estimatedRowCount) && Objects.equals(this.analyticalFootprintInMbs, other.analyticalFootprintInMbs) && Objects.equals(this.errorComment, other.errorComment) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tableName == null ? 43 : this.tableName.hashCode());
        result = result * 59 + (this.toLoadColumnCount == null ? 43 : this.toLoadColumnCount.hashCode());
        result = result * 59 + (this.varlenColumnCount == null ? 43 : this.varlenColumnCount.hashCode());
        result = result * 59 + (this.estimatedRowCount == null ? 43 : this.estimatedRowCount.hashCode());
        result = result * 59 + (this.analyticalFootprintInMbs == null ? 43 : this.analyticalFootprintInMbs.hashCode());
        result = result * 59 + (this.errorComment == null ? 43 : this.errorComment.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tableName")
        private String tableName;
        @JsonProperty(value="toLoadColumnCount")
        private Integer toLoadColumnCount;
        @JsonProperty(value="varlenColumnCount")
        private Integer varlenColumnCount;
        @JsonProperty(value="estimatedRowCount")
        private Long estimatedRowCount;
        @JsonProperty(value="analyticalFootprintInMbs")
        private Long analyticalFootprintInMbs;
        @JsonProperty(value="errorComment")
        private String errorComment;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            this.__explicitlySet__.add("tableName");
            return this;
        }

        public Builder toLoadColumnCount(Integer toLoadColumnCount) {
            this.toLoadColumnCount = toLoadColumnCount;
            this.__explicitlySet__.add("toLoadColumnCount");
            return this;
        }

        public Builder varlenColumnCount(Integer varlenColumnCount) {
            this.varlenColumnCount = varlenColumnCount;
            this.__explicitlySet__.add("varlenColumnCount");
            return this;
        }

        public Builder estimatedRowCount(Long estimatedRowCount) {
            this.estimatedRowCount = estimatedRowCount;
            this.__explicitlySet__.add("estimatedRowCount");
            return this;
        }

        public Builder analyticalFootprintInMbs(Long analyticalFootprintInMbs) {
            this.analyticalFootprintInMbs = analyticalFootprintInMbs;
            this.__explicitlySet__.add("analyticalFootprintInMbs");
            return this;
        }

        public Builder errorComment(String errorComment) {
            this.errorComment = errorComment;
            this.__explicitlySet__.add("errorComment");
            return this;
        }

        public AnalyticsClusterTableMemoryEstimate build() {
            AnalyticsClusterTableMemoryEstimate model = new AnalyticsClusterTableMemoryEstimate(this.tableName, this.toLoadColumnCount, this.varlenColumnCount, this.estimatedRowCount, this.analyticalFootprintInMbs, this.errorComment);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnalyticsClusterTableMemoryEstimate model) {
            if (model.wasPropertyExplicitlySet("tableName")) {
                this.tableName(model.getTableName());
            }
            if (model.wasPropertyExplicitlySet("toLoadColumnCount")) {
                this.toLoadColumnCount(model.getToLoadColumnCount());
            }
            if (model.wasPropertyExplicitlySet("varlenColumnCount")) {
                this.varlenColumnCount(model.getVarlenColumnCount());
            }
            if (model.wasPropertyExplicitlySet("estimatedRowCount")) {
                this.estimatedRowCount(model.getEstimatedRowCount());
            }
            if (model.wasPropertyExplicitlySet("analyticalFootprintInMbs")) {
                this.analyticalFootprintInMbs(model.getAnalyticalFootprintInMbs());
            }
            if (model.wasPropertyExplicitlySet("errorComment")) {
                this.errorComment(model.getErrorComment());
            }
            return this;
        }
    }
}

