/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.Replicas;
import com.oracle.bmc.mysql.model.ReplicaSummary;
import com.oracle.bmc.mysql.requests.ListReplicasRequest;
import com.oracle.bmc.mysql.responses.ListReplicasResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReplicasPaginators {
    private final Replicas client;

    public ReplicasPaginators(Replicas client) {
        this.client = client;
    }

    public Iterable<ListReplicasResponse> listReplicasResponseIterator(final ListReplicasRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicasRequest.Builder>(){

            @Override
            public ListReplicasRequest.Builder get() {
                return ListReplicasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicasResponse, String>(){

            @Override
            public String apply(ListReplicasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicasRequest.Builder>, ListReplicasRequest>(){

            @Override
            public ListReplicasRequest apply(RequestBuilderAndToken<ListReplicasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicasRequest, ListReplicasResponse>(){

            @Override
            public ListReplicasResponse apply(ListReplicasRequest request) {
                return ReplicasPaginators.this.client.listReplicas(request);
            }
        });
    }

    public Iterable<ReplicaSummary> listReplicasRecordIterator(final ListReplicasRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicasRequest.Builder>(){

            @Override
            public ListReplicasRequest.Builder get() {
                return ListReplicasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicasResponse, String>(){

            @Override
            public String apply(ListReplicasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicasRequest.Builder>, ListReplicasRequest>(){

            @Override
            public ListReplicasRequest apply(RequestBuilderAndToken<ListReplicasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicasRequest, ListReplicasResponse>(){

            @Override
            public ListReplicasResponse apply(ListReplicasRequest request) {
                return ReplicasPaginators.this.client.listReplicas(request);
            }
        }, (Function)new Function<ListReplicasResponse, List<ReplicaSummary>>(){

            @Override
            public List<ReplicaSummary> apply(ListReplicasResponse response) {
                return response.getItems();
            }
        });
    }
}

