/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.Channels;
import com.oracle.bmc.mysql.model.ChannelSummary;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChannelsPaginators {
    private final Channels client;

    public ChannelsPaginators(Channels client) {
        this.client = client;
    }

    public Iterable<ListChannelsResponse> listChannelsResponseIterator(final ListChannelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListChannelsRequest.Builder>(){

            @Override
            public ListChannelsRequest.Builder get() {
                return ListChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListChannelsResponse, String>(){

            @Override
            public String apply(ListChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListChannelsRequest.Builder>, ListChannelsRequest>(){

            @Override
            public ListChannelsRequest apply(RequestBuilderAndToken<ListChannelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListChannelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListChannelsRequest, ListChannelsResponse>(){

            @Override
            public ListChannelsResponse apply(ListChannelsRequest request) {
                return ChannelsPaginators.this.client.listChannels(request);
            }
        });
    }

    public Iterable<ChannelSummary> listChannelsRecordIterator(final ListChannelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListChannelsRequest.Builder>(){

            @Override
            public ListChannelsRequest.Builder get() {
                return ListChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListChannelsResponse, String>(){

            @Override
            public String apply(ListChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListChannelsRequest.Builder>, ListChannelsRequest>(){

            @Override
            public ListChannelsRequest apply(RequestBuilderAndToken<ListChannelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListChannelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListChannelsRequest, ListChannelsResponse>(){

            @Override
            public ListChannelsResponse apply(ListChannelsRequest request) {
                return ChannelsPaginators.this.client.listChannels(request);
            }
        }, (Function)new Function<ListChannelsResponse, List<ChannelSummary>>(){

            @Override
            public List<ChannelSummary> apply(ListChannelsResponse response) {
                return response.getItems();
            }
        });
    }
}

