/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mysql.Channels;
import com.oracle.bmc.mysql.ChannelsAsyncClient;
import com.oracle.bmc.mysql.ChannelsPaginators;
import com.oracle.bmc.mysql.ChannelsWaiters;
import com.oracle.bmc.mysql.model.Channel;
import com.oracle.bmc.mysql.model.ChannelSummary;
import com.oracle.bmc.mysql.requests.CreateChannelRequest;
import com.oracle.bmc.mysql.requests.DeleteChannelRequest;
import com.oracle.bmc.mysql.requests.GetChannelRequest;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.requests.ResetChannelRequest;
import com.oracle.bmc.mysql.requests.ResumeChannelRequest;
import com.oracle.bmc.mysql.requests.UpdateChannelRequest;
import com.oracle.bmc.mysql.responses.CreateChannelResponse;
import com.oracle.bmc.mysql.responses.DeleteChannelResponse;
import com.oracle.bmc.mysql.responses.GetChannelResponse;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.mysql.responses.ResetChannelResponse;
import com.oracle.bmc.mysql.responses.ResumeChannelResponse;
import com.oracle.bmc.mysql.responses.UpdateChannelResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelsClient
extends BaseSyncClient
implements Channels {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CHANNELS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ChannelsAsyncClient.class);
    private final ChannelsWaiters waiters;
    private final ChannelsPaginators paginators;

    private ChannelsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Channels-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ChannelsWaiters(executorService, this);
        this.paginators = new ChannelsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest request) {
        Objects.requireNonNull(request.getCreateChannelDetails(), "createChannelDetails is required");
        return (CreateChannelResponse)this.clientCall(request, CreateChannelResponse::builder).logger(LOG, "createChannel").serviceDetails("Channels", "CreateChannel", "").method(Method.POST).requestBuilder(CreateChannelRequest::builder).basePath("/20190415").appendPathParam("channels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Channel.class, CreateChannelResponse.Builder::channel).handleResponseHeaderString("etag", CreateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateChannelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest request) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (DeleteChannelResponse)this.clientCall(request, DeleteChannelResponse::builder).logger(LOG, "deleteChannel").serviceDetails("Channels", "DeleteChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/DeleteChannel").method(Method.DELETE).requestBuilder(DeleteChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteChannelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetChannelResponse getChannel(GetChannelRequest request) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (GetChannelResponse)this.clientCall(request, GetChannelResponse::builder).logger(LOG, "getChannel").serviceDetails("Channels", "GetChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/GetChannel").method(Method.GET).requestBuilder(GetChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Channel.class, GetChannelResponse.Builder::channel).handleResponseHeaderString("etag", GetChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListChannelsResponse)this.clientCall(request, ListChannelsResponse::builder).logger(LOG, "listChannels").serviceDetails("Channels", "ListChannels", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ChannelSummary/ListChannels").method(Method.GET).requestBuilder(ListChannelsRequest::builder).basePath("/20190415").appendPathParam("channels").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("channelId", (Object)request.getChannelId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ChannelSummary.class, ListChannelsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListChannelsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ResetChannelResponse resetChannel(ResetChannelRequest request) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (ResetChannelResponse)this.clientCall(request, ResetChannelResponse::builder).logger(LOG, "resetChannel").serviceDetails("Channels", "ResetChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/ResetChannel").method(Method.POST).requestBuilder(ResetChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("reset").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", ResetChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ResetChannelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ResumeChannelResponse resumeChannel(ResumeChannelRequest request) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (ResumeChannelResponse)this.clientCall(request, ResumeChannelResponse::builder).logger(LOG, "resumeChannel").serviceDetails("Channels", "ResumeChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/ResumeChannel").method(Method.POST).requestBuilder(ResumeChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", ResumeChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ResumeChannelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest request) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateChannelDetails(), "updateChannelDetails is required");
        return (UpdateChannelResponse)this.clientCall(request, UpdateChannelResponse::builder).logger(LOG, "updateChannel").serviceDetails("Channels", "UpdateChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/UpdateChannel").method(Method.PUT).requestBuilder(UpdateChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateChannelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChannelsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ChannelsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ChannelsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ChannelsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ChannelsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ChannelsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ChannelsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ChannelsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ChannelsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ChannelsClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

