/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.UpdateMediaWorkflowDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMediaWorkflowRequest
extends BmcRequest<UpdateMediaWorkflowDetails> {
    private String mediaWorkflowId;
    private UpdateMediaWorkflowDetails updateMediaWorkflowDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getMediaWorkflowId() {
        return this.mediaWorkflowId;
    }

    public UpdateMediaWorkflowDetails getUpdateMediaWorkflowDetails() {
        return this.updateMediaWorkflowDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMediaWorkflowDetails getBody$() {
        return this.updateMediaWorkflowDetails;
    }

    public Builder toBuilder() {
        return new Builder().mediaWorkflowId(this.mediaWorkflowId).updateMediaWorkflowDetails(this.updateMediaWorkflowDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaWorkflowId=").append(String.valueOf(this.mediaWorkflowId));
        sb.append(",updateMediaWorkflowDetails=").append(String.valueOf((Object)this.updateMediaWorkflowDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMediaWorkflowRequest)) {
            return false;
        }
        UpdateMediaWorkflowRequest other = (UpdateMediaWorkflowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaWorkflowId, other.mediaWorkflowId) && Objects.equals((Object)this.updateMediaWorkflowDetails, (Object)other.updateMediaWorkflowDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaWorkflowId == null ? 43 : this.mediaWorkflowId.hashCode());
        result = result * 59 + (this.updateMediaWorkflowDetails == null ? 43 : this.updateMediaWorkflowDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMediaWorkflowRequest, UpdateMediaWorkflowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaWorkflowId = null;
        private UpdateMediaWorkflowDetails updateMediaWorkflowDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder mediaWorkflowId(String mediaWorkflowId) {
            this.mediaWorkflowId = mediaWorkflowId;
            return this;
        }

        public Builder updateMediaWorkflowDetails(UpdateMediaWorkflowDetails updateMediaWorkflowDetails) {
            this.updateMediaWorkflowDetails = updateMediaWorkflowDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMediaWorkflowRequest o) {
            this.mediaWorkflowId(o.getMediaWorkflowId());
            this.updateMediaWorkflowDetails(o.getUpdateMediaWorkflowDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMediaWorkflowRequest build() {
            UpdateMediaWorkflowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMediaWorkflowDetails body) {
            this.updateMediaWorkflowDetails(body);
            return this;
        }

        public UpdateMediaWorkflowRequest buildWithoutInvocationCallback() {
            UpdateMediaWorkflowRequest request = new UpdateMediaWorkflowRequest();
            request.mediaWorkflowId = this.mediaWorkflowId;
            request.updateMediaWorkflowDetails = this.updateMediaWorkflowDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

