/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListSystemMediaWorkflowsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String name;
    private SortOrder sortOrder;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).name(this.name).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSystemMediaWorkflowsRequest)) {
            return false;
        }
        ListSystemMediaWorkflowsRequest other = (ListSystemMediaWorkflowsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSystemMediaWorkflowsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String name = null;
        private SortOrder sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSystemMediaWorkflowsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSystemMediaWorkflowsRequest build() {
            ListSystemMediaWorkflowsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSystemMediaWorkflowsRequest buildWithoutInvocationCallback() {
            ListSystemMediaWorkflowsRequest request = new ListSystemMediaWorkflowsRequest();
            request.compartmentId = this.compartmentId;
            request.name = this.name;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

