/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.MediaWorkflowTaskDeclarationSortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListMediaWorkflowTaskDeclarationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String name;
    private Integer version;
    private Boolean isCurrent;
    private MediaWorkflowTaskDeclarationSortBy sortBy;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getIsCurrent() {
        return this.isCurrent;
    }

    public MediaWorkflowTaskDeclarationSortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).name(this.name).version(this.version).isCurrent(this.isCurrent).sortBy(this.sortBy).limit(this.limit).page(this.page).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(",isCurrent=").append(String.valueOf(this.isCurrent));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMediaWorkflowTaskDeclarationsRequest)) {
            return false;
        }
        ListMediaWorkflowTaskDeclarationsRequest other = (ListMediaWorkflowTaskDeclarationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.isCurrent, other.isCurrent) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.isCurrent == null ? 43 : this.isCurrent.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMediaWorkflowTaskDeclarationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String name = null;
        private Integer version = null;
        private Boolean isCurrent = null;
        private MediaWorkflowTaskDeclarationSortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder isCurrent(Boolean isCurrent) {
            this.isCurrent = isCurrent;
            return this;
        }

        public Builder sortBy(MediaWorkflowTaskDeclarationSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMediaWorkflowTaskDeclarationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.version(o.getVersion());
            this.isCurrent(o.getIsCurrent());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMediaWorkflowTaskDeclarationsRequest build() {
            ListMediaWorkflowTaskDeclarationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMediaWorkflowTaskDeclarationsRequest buildWithoutInvocationCallback() {
            ListMediaWorkflowTaskDeclarationsRequest request = new ListMediaWorkflowTaskDeclarationsRequest();
            request.compartmentId = this.compartmentId;
            request.name = this.name;
            request.version = this.version;
            request.isCurrent = this.isCurrent;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

