/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJob;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobSortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListMediaWorkflowJobsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String id;
    private String mediaWorkflowId;
    private String displayName;
    private MediaWorkflowJob.LifecycleState lifecycleState;
    private String page;
    private Integer limit;
    private MediaWorkflowJobSortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getMediaWorkflowId() {
        return this.mediaWorkflowId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MediaWorkflowJob.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public MediaWorkflowJobSortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).id(this.id).mediaWorkflowId(this.mediaWorkflowId).displayName(this.displayName).lifecycleState(this.lifecycleState).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",mediaWorkflowId=").append(String.valueOf(this.mediaWorkflowId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMediaWorkflowJobsRequest)) {
            return false;
        }
        ListMediaWorkflowJobsRequest other = (ListMediaWorkflowJobsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.mediaWorkflowId, other.mediaWorkflowId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.mediaWorkflowId == null ? 43 : this.mediaWorkflowId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMediaWorkflowJobsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String id = null;
        private String mediaWorkflowId = null;
        private String displayName = null;
        private MediaWorkflowJob.LifecycleState lifecycleState = null;
        private String page = null;
        private Integer limit = null;
        private MediaWorkflowJobSortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder mediaWorkflowId(String mediaWorkflowId) {
            this.mediaWorkflowId = mediaWorkflowId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(MediaWorkflowJob.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(MediaWorkflowJobSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMediaWorkflowJobsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.id(o.getId());
            this.mediaWorkflowId(o.getMediaWorkflowId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMediaWorkflowJobsRequest build() {
            ListMediaWorkflowJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMediaWorkflowJobsRequest buildWithoutInvocationCallback() {
            ListMediaWorkflowJobsRequest request = new ListMediaWorkflowJobsRequest();
            request.compartmentId = this.compartmentId;
            request.id = this.id;
            request.mediaWorkflowId = this.mediaWorkflowId;
            request.displayName = this.displayName;
            request.lifecycleState = this.lifecycleState;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

