/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.AssetType;
import com.oracle.bmc.mediaservices.model.LifecycleState;
import com.oracle.bmc.mediaservices.model.MediaAssetSortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListMediaAssetsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private Integer limit;
    private String page;
    private LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private MediaAssetSortBy sortBy;
    private String opcRequestId;
    private String distributionChannelId;
    private String parentMediaAssetId;
    private String masterMediaAssetId;
    private AssetType type;
    private String bucketName;
    private String objectName;
    private String mediaWorkflowJobId;
    private String sourceMediaWorkflowId;
    private Long sourceMediaWorkflowVersion;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public MediaAssetSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public String getParentMediaAssetId() {
        return this.parentMediaAssetId;
    }

    public String getMasterMediaAssetId() {
        return this.masterMediaAssetId;
    }

    public AssetType getType() {
        return this.type;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public String getSourceMediaWorkflowId() {
        return this.sourceMediaWorkflowId;
    }

    public Long getSourceMediaWorkflowVersion() {
        return this.sourceMediaWorkflowVersion;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).distributionChannelId(this.distributionChannelId).parentMediaAssetId(this.parentMediaAssetId).masterMediaAssetId(this.masterMediaAssetId).type(this.type).bucketName(this.bucketName).objectName(this.objectName).mediaWorkflowJobId(this.mediaWorkflowJobId).sourceMediaWorkflowId(this.sourceMediaWorkflowId).sourceMediaWorkflowVersion(this.sourceMediaWorkflowVersion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(",parentMediaAssetId=").append(String.valueOf(this.parentMediaAssetId));
        sb.append(",masterMediaAssetId=").append(String.valueOf(this.masterMediaAssetId));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(",sourceMediaWorkflowId=").append(String.valueOf(this.sourceMediaWorkflowId));
        sb.append(",sourceMediaWorkflowVersion=").append(String.valueOf(this.sourceMediaWorkflowVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMediaAssetsRequest)) {
            return false;
        }
        ListMediaAssetsRequest other = (ListMediaAssetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.distributionChannelId, other.distributionChannelId) && Objects.equals(this.parentMediaAssetId, other.parentMediaAssetId) && Objects.equals(this.masterMediaAssetId, other.masterMediaAssetId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && Objects.equals(this.sourceMediaWorkflowId, other.sourceMediaWorkflowId) && Objects.equals(this.sourceMediaWorkflowVersion, other.sourceMediaWorkflowVersion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        result = result * 59 + (this.parentMediaAssetId == null ? 43 : this.parentMediaAssetId.hashCode());
        result = result * 59 + (this.masterMediaAssetId == null ? 43 : this.masterMediaAssetId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + (this.sourceMediaWorkflowId == null ? 43 : this.sourceMediaWorkflowId.hashCode());
        result = result * 59 + (this.sourceMediaWorkflowVersion == null ? 43 : this.sourceMediaWorkflowVersion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMediaAssetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private LifecycleState lifecycleState = null;
        private SortOrder sortOrder = null;
        private MediaAssetSortBy sortBy = null;
        private String opcRequestId = null;
        private String distributionChannelId = null;
        private String parentMediaAssetId = null;
        private String masterMediaAssetId = null;
        private AssetType type = null;
        private String bucketName = null;
        private String objectName = null;
        private String mediaWorkflowJobId = null;
        private String sourceMediaWorkflowId = null;
        private Long sourceMediaWorkflowVersion = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(MediaAssetSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            return this;
        }

        public Builder parentMediaAssetId(String parentMediaAssetId) {
            this.parentMediaAssetId = parentMediaAssetId;
            return this;
        }

        public Builder masterMediaAssetId(String masterMediaAssetId) {
            this.masterMediaAssetId = masterMediaAssetId;
            return this;
        }

        public Builder type(AssetType type) {
            this.type = type;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            return this;
        }

        public Builder sourceMediaWorkflowId(String sourceMediaWorkflowId) {
            this.sourceMediaWorkflowId = sourceMediaWorkflowId;
            return this;
        }

        public Builder sourceMediaWorkflowVersion(Long sourceMediaWorkflowVersion) {
            this.sourceMediaWorkflowVersion = sourceMediaWorkflowVersion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMediaAssetsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.distributionChannelId(o.getDistributionChannelId());
            this.parentMediaAssetId(o.getParentMediaAssetId());
            this.masterMediaAssetId(o.getMasterMediaAssetId());
            this.type(o.getType());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.mediaWorkflowJobId(o.getMediaWorkflowJobId());
            this.sourceMediaWorkflowId(o.getSourceMediaWorkflowId());
            this.sourceMediaWorkflowVersion(o.getSourceMediaWorkflowVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMediaAssetsRequest build() {
            ListMediaAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMediaAssetsRequest buildWithoutInvocationCallback() {
            ListMediaAssetsRequest request = new ListMediaAssetsRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.distributionChannelId = this.distributionChannelId;
            request.parentMediaAssetId = this.parentMediaAssetId;
            request.masterMediaAssetId = this.masterMediaAssetId;
            request.type = this.type;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.mediaWorkflowJobId = this.mediaWorkflowJobId;
            request.sourceMediaWorkflowId = this.sourceMediaWorkflowId;
            request.sourceMediaWorkflowVersion = this.sourceMediaWorkflowVersion;
            return request;
        }
    }
}

