/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMediaWorkflowJobRequest
extends BmcRequest<Void> {
    private String mediaWorkflowJobId;
    private String opcRequestId;

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().mediaWorkflowJobId(this.mediaWorkflowJobId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMediaWorkflowJobRequest)) {
            return false;
        }
        GetMediaWorkflowJobRequest other = (GetMediaWorkflowJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMediaWorkflowJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaWorkflowJobId = null;
        private String opcRequestId = null;

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMediaWorkflowJobRequest o) {
            this.mediaWorkflowJobId(o.getMediaWorkflowJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMediaWorkflowJobRequest build() {
            GetMediaWorkflowJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMediaWorkflowJobRequest buildWithoutInvocationCallback() {
            GetMediaWorkflowJobRequest request = new GetMediaWorkflowJobRequest();
            request.mediaWorkflowJobId = this.mediaWorkflowJobId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

