/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMediaWorkflowConfigurationRequest
extends BmcRequest<Void> {
    private String mediaWorkflowConfigurationId;
    private String opcRequestId;

    public String getMediaWorkflowConfigurationId() {
        return this.mediaWorkflowConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().mediaWorkflowConfigurationId(this.mediaWorkflowConfigurationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaWorkflowConfigurationId=").append(String.valueOf(this.mediaWorkflowConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMediaWorkflowConfigurationRequest)) {
            return false;
        }
        GetMediaWorkflowConfigurationRequest other = (GetMediaWorkflowConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaWorkflowConfigurationId, other.mediaWorkflowConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaWorkflowConfigurationId == null ? 43 : this.mediaWorkflowConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMediaWorkflowConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaWorkflowConfigurationId = null;
        private String opcRequestId = null;

        public Builder mediaWorkflowConfigurationId(String mediaWorkflowConfigurationId) {
            this.mediaWorkflowConfigurationId = mediaWorkflowConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMediaWorkflowConfigurationRequest o) {
            this.mediaWorkflowConfigurationId(o.getMediaWorkflowConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMediaWorkflowConfigurationRequest build() {
            GetMediaWorkflowConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMediaWorkflowConfigurationRequest buildWithoutInvocationCallback() {
            GetMediaWorkflowConfigurationRequest request = new GetMediaWorkflowConfigurationRequest();
            request.mediaWorkflowConfigurationId = this.mediaWorkflowConfigurationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

