/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteStreamCdnConfigRequest
extends BmcRequest<Void> {
    private String streamCdnConfigId;
    private String opcRequestId;
    private String ifMatch;

    public String getStreamCdnConfigId() {
        return this.streamCdnConfigId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().streamCdnConfigId(this.streamCdnConfigId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamCdnConfigId=").append(String.valueOf(this.streamCdnConfigId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteStreamCdnConfigRequest)) {
            return false;
        }
        DeleteStreamCdnConfigRequest other = (DeleteStreamCdnConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamCdnConfigId, other.streamCdnConfigId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamCdnConfigId == null ? 43 : this.streamCdnConfigId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteStreamCdnConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamCdnConfigId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder streamCdnConfigId(String streamCdnConfigId) {
            this.streamCdnConfigId = streamCdnConfigId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteStreamCdnConfigRequest o) {
            this.streamCdnConfigId(o.getStreamCdnConfigId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteStreamCdnConfigRequest build() {
            DeleteStreamCdnConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteStreamCdnConfigRequest buildWithoutInvocationCallback() {
            DeleteStreamCdnConfigRequest request = new DeleteStreamCdnConfigRequest();
            request.streamCdnConfigId = this.streamCdnConfigId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

