/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.DeleteMode;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteMediaAssetRequest
extends BmcRequest<Void> {
    private String mediaAssetId;
    private String ifMatch;
    private String opcRequestId;
    private DeleteMode deleteMode;

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DeleteMode getDeleteMode() {
        return this.deleteMode;
    }

    public Builder toBuilder() {
        return new Builder().mediaAssetId(this.mediaAssetId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).deleteMode(this.deleteMode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",deleteMode=").append(String.valueOf((Object)this.deleteMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteMediaAssetRequest)) {
            return false;
        }
        DeleteMediaAssetRequest other = (DeleteMediaAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.deleteMode, (Object)other.deleteMode);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.deleteMode == null ? 43 : this.deleteMode.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteMediaAssetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaAssetId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private DeleteMode deleteMode = null;

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder deleteMode(DeleteMode deleteMode) {
            this.deleteMode = deleteMode;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteMediaAssetRequest o) {
            this.mediaAssetId(o.getMediaAssetId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.deleteMode(o.getDeleteMode());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteMediaAssetRequest build() {
            DeleteMediaAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteMediaAssetRequest buildWithoutInvocationCallback() {
            DeleteMediaAssetRequest request = new DeleteMediaAssetRequest();
            request.mediaAssetId = this.mediaAssetId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.deleteMode = this.deleteMode;
            return request;
        }
    }
}

