/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MediaWorkflowTaskDeclaration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final Integer version;
    @JsonProperty(value="parametersSchema")
    private final Map<String, Object> parametersSchema;
    @JsonProperty(value="parametersSchemaAllowingReferences")
    private final Map<String, Object> parametersSchemaAllowingReferences;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "parametersSchema", "parametersSchemaAllowingReferences"})
    public MediaWorkflowTaskDeclaration(String name, Integer version, Map<String, Object> parametersSchema, Map<String, Object> parametersSchemaAllowingReferences) {
        this.name = name;
        this.version = version;
        this.parametersSchema = parametersSchema;
        this.parametersSchemaAllowingReferences = parametersSchemaAllowingReferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Map<String, Object> getParametersSchema() {
        return this.parametersSchema;
    }

    public Map<String, Object> getParametersSchemaAllowingReferences() {
        return this.parametersSchemaAllowingReferences;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaWorkflowTaskDeclaration(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", parametersSchema=").append(String.valueOf(this.parametersSchema));
        sb.append(", parametersSchemaAllowingReferences=").append(String.valueOf(this.parametersSchemaAllowingReferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaWorkflowTaskDeclaration)) {
            return false;
        }
        MediaWorkflowTaskDeclaration other = (MediaWorkflowTaskDeclaration)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.parametersSchema, other.parametersSchema) && Objects.equals(this.parametersSchemaAllowingReferences, other.parametersSchemaAllowingReferences) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.parametersSchema == null ? 43 : this.parametersSchema.hashCode());
        result = result * 59 + (this.parametersSchemaAllowingReferences == null ? 43 : this.parametersSchemaAllowingReferences.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private Integer version;
        @JsonProperty(value="parametersSchema")
        private Map<String, Object> parametersSchema;
        @JsonProperty(value="parametersSchemaAllowingReferences")
        private Map<String, Object> parametersSchemaAllowingReferences;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder parametersSchema(Map<String, Object> parametersSchema) {
            this.parametersSchema = parametersSchema;
            this.__explicitlySet__.add("parametersSchema");
            return this;
        }

        public Builder parametersSchemaAllowingReferences(Map<String, Object> parametersSchemaAllowingReferences) {
            this.parametersSchemaAllowingReferences = parametersSchemaAllowingReferences;
            this.__explicitlySet__.add("parametersSchemaAllowingReferences");
            return this;
        }

        public MediaWorkflowTaskDeclaration build() {
            MediaWorkflowTaskDeclaration model = new MediaWorkflowTaskDeclaration(this.name, this.version, this.parametersSchema, this.parametersSchemaAllowingReferences);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MediaWorkflowTaskDeclaration model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("parametersSchema")) {
                this.parametersSchema(model.getParametersSchema());
            }
            if (model.wasPropertyExplicitlySet("parametersSchemaAllowingReferences")) {
                this.parametersSchemaAllowingReferences(model.getParametersSchemaAllowingReferences());
            }
            return this;
        }
    }
}

