/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MediaAssetDistributionChannelAttachmentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="mediaAssetId")
    private final String mediaAssetId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="distributionChannelId")
    private final String distributionChannelId;
    @JsonProperty(value="version")
    private final Long version;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="metadataRef")
    private final String metadataRef;
    @JsonProperty(value="mediaWorkflowJobId")
    private final String mediaWorkflowJobId;

    @Deprecated
    @ConstructorProperties(value={"mediaAssetId", "displayName", "distributionChannelId", "version", "lifecycleState", "metadataRef", "mediaWorkflowJobId"})
    public MediaAssetDistributionChannelAttachmentSummary(String mediaAssetId, String displayName, String distributionChannelId, Long version, LifecycleState lifecycleState, String metadataRef, String mediaWorkflowJobId) {
        this.mediaAssetId = mediaAssetId;
        this.displayName = displayName;
        this.distributionChannelId = distributionChannelId;
        this.version = version;
        this.lifecycleState = lifecycleState;
        this.metadataRef = metadataRef;
        this.mediaWorkflowJobId = mediaWorkflowJobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public Long getVersion() {
        return this.version;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getMetadataRef() {
        return this.metadataRef;
    }

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaAssetDistributionChannelAttachmentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", metadataRef=").append(String.valueOf(this.metadataRef));
        sb.append(", mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaAssetDistributionChannelAttachmentSummary)) {
            return false;
        }
        MediaAssetDistributionChannelAttachmentSummary other = (MediaAssetDistributionChannelAttachmentSummary)((Object)o);
        return Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.distributionChannelId, other.distributionChannelId) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.metadataRef, other.metadataRef) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.metadataRef == null ? 43 : this.metadataRef.hashCode());
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        NeedsAttention("NEEDS_ATTENTION"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mediaAssetId")
        private String mediaAssetId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="distributionChannelId")
        private String distributionChannelId;
        @JsonProperty(value="version")
        private Long version;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="metadataRef")
        private String metadataRef;
        @JsonProperty(value="mediaWorkflowJobId")
        private String mediaWorkflowJobId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            this.__explicitlySet__.add("mediaAssetId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            this.__explicitlySet__.add("distributionChannelId");
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder metadataRef(String metadataRef) {
            this.metadataRef = metadataRef;
            this.__explicitlySet__.add("metadataRef");
            return this;
        }

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            this.__explicitlySet__.add("mediaWorkflowJobId");
            return this;
        }

        public MediaAssetDistributionChannelAttachmentSummary build() {
            MediaAssetDistributionChannelAttachmentSummary model = new MediaAssetDistributionChannelAttachmentSummary(this.mediaAssetId, this.displayName, this.distributionChannelId, this.version, this.lifecycleState, this.metadataRef, this.mediaWorkflowJobId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MediaAssetDistributionChannelAttachmentSummary model) {
            if (model.wasPropertyExplicitlySet("mediaAssetId")) {
                this.mediaAssetId(model.getMediaAssetId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("distributionChannelId")) {
                this.distributionChannelId(model.getDistributionChannelId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("metadataRef")) {
                this.metadataRef(model.getMetadataRef());
            }
            if (model.wasPropertyExplicitlySet("mediaWorkflowJobId")) {
                this.mediaWorkflowJobId(model.getMediaWorkflowJobId());
            }
            return this;
        }
    }
}

