/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfigEncryption;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateStreamPackagingConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="distributionChannelId")
    private final String distributionChannelId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="streamPackagingFormat")
    private final StreamPackagingFormat streamPackagingFormat;
    @JsonProperty(value="segmentTimeInSeconds")
    private final Integer segmentTimeInSeconds;
    @JsonProperty(value="encryption")
    private final StreamPackagingConfigEncryption encryption;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"distributionChannelId", "displayName", "streamPackagingFormat", "segmentTimeInSeconds", "encryption", "freeformTags", "definedTags"})
    public CreateStreamPackagingConfigDetails(String distributionChannelId, String displayName, StreamPackagingFormat streamPackagingFormat, Integer segmentTimeInSeconds, StreamPackagingConfigEncryption encryption, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.distributionChannelId = distributionChannelId;
        this.displayName = displayName;
        this.streamPackagingFormat = streamPackagingFormat;
        this.segmentTimeInSeconds = segmentTimeInSeconds;
        this.encryption = encryption;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public StreamPackagingFormat getStreamPackagingFormat() {
        return this.streamPackagingFormat;
    }

    public Integer getSegmentTimeInSeconds() {
        return this.segmentTimeInSeconds;
    }

    public StreamPackagingConfigEncryption getEncryption() {
        return this.encryption;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateStreamPackagingConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", streamPackagingFormat=").append(String.valueOf((Object)this.streamPackagingFormat));
        sb.append(", segmentTimeInSeconds=").append(String.valueOf(this.segmentTimeInSeconds));
        sb.append(", encryption=").append(String.valueOf((Object)this.encryption));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateStreamPackagingConfigDetails)) {
            return false;
        }
        CreateStreamPackagingConfigDetails other = (CreateStreamPackagingConfigDetails)((Object)o);
        return Objects.equals(this.distributionChannelId, other.distributionChannelId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.streamPackagingFormat, (Object)other.streamPackagingFormat) && Objects.equals(this.segmentTimeInSeconds, other.segmentTimeInSeconds) && Objects.equals((Object)this.encryption, (Object)other.encryption) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.streamPackagingFormat == null ? 43 : this.streamPackagingFormat.hashCode());
        result = result * 59 + (this.segmentTimeInSeconds == null ? 43 : this.segmentTimeInSeconds.hashCode());
        result = result * 59 + (this.encryption == null ? 43 : this.encryption.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StreamPackagingFormat implements BmcEnum
    {
        Hls("HLS"),
        Dash("DASH");

        private final String value;
        private static Map<String, StreamPackagingFormat> map;

        private StreamPackagingFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StreamPackagingFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid StreamPackagingFormat: " + key);
        }

        static {
            map = new HashMap<String, StreamPackagingFormat>();
            for (StreamPackagingFormat v : StreamPackagingFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="distributionChannelId")
        private String distributionChannelId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="streamPackagingFormat")
        private StreamPackagingFormat streamPackagingFormat;
        @JsonProperty(value="segmentTimeInSeconds")
        private Integer segmentTimeInSeconds;
        @JsonProperty(value="encryption")
        private StreamPackagingConfigEncryption encryption;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            this.__explicitlySet__.add("distributionChannelId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder streamPackagingFormat(StreamPackagingFormat streamPackagingFormat) {
            this.streamPackagingFormat = streamPackagingFormat;
            this.__explicitlySet__.add("streamPackagingFormat");
            return this;
        }

        public Builder segmentTimeInSeconds(Integer segmentTimeInSeconds) {
            this.segmentTimeInSeconds = segmentTimeInSeconds;
            this.__explicitlySet__.add("segmentTimeInSeconds");
            return this;
        }

        public Builder encryption(StreamPackagingConfigEncryption encryption) {
            this.encryption = encryption;
            this.__explicitlySet__.add("encryption");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateStreamPackagingConfigDetails build() {
            CreateStreamPackagingConfigDetails model = new CreateStreamPackagingConfigDetails(this.distributionChannelId, this.displayName, this.streamPackagingFormat, this.segmentTimeInSeconds, this.encryption, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateStreamPackagingConfigDetails model) {
            if (model.wasPropertyExplicitlySet("distributionChannelId")) {
                this.distributionChannelId(model.getDistributionChannelId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("streamPackagingFormat")) {
                this.streamPackagingFormat(model.getStreamPackagingFormat());
            }
            if (model.wasPropertyExplicitlySet("segmentTimeInSeconds")) {
                this.segmentTimeInSeconds(model.getSegmentTimeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("encryption")) {
                this.encryption(model.getEncryption());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

