/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.mediaservices.model.IngestStreamDistributionChannelDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ingestPayloadType")
@JsonFilter(value="explicitlySetFilter")
public final class AssetMetadataEntryDetails
extends IngestStreamDistributionChannelDetails {
    @JsonProperty(value="mediaAssetId")
    private final String mediaAssetId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AssetMetadataEntryDetails(String mediaAssetId, String compartmentId) {
        this.mediaAssetId = mediaAssetId;
        this.compartmentId = compartmentId;
    }

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssetMetadataEntryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssetMetadataEntryDetails)) {
            return false;
        }
        AssetMetadataEntryDetails other = (AssetMetadataEntryDetails)((Object)o);
        return Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mediaAssetId")
        private String mediaAssetId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            this.__explicitlySet__.add("mediaAssetId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public AssetMetadataEntryDetails build() {
            AssetMetadataEntryDetails model = new AssetMetadataEntryDetails(this.mediaAssetId, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssetMetadataEntryDetails model) {
            if (model.wasPropertyExplicitlySet("mediaAssetId")) {
                this.mediaAssetId(model.getMediaAssetId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

