/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices;

import com.oracle.bmc.mediaservices.MediaServices;
import com.oracle.bmc.mediaservices.model.LifecycleState;
import com.oracle.bmc.mediaservices.model.MediaAssetDistributionChannelAttachment;
import com.oracle.bmc.mediaservices.model.MediaWorkflow;
import com.oracle.bmc.mediaservices.model.MediaWorkflowConfiguration;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJob;
import com.oracle.bmc.mediaservices.model.StreamCdnConfig;
import com.oracle.bmc.mediaservices.model.StreamDistributionChannel;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfig;
import com.oracle.bmc.mediaservices.requests.GetMediaAssetDistributionChannelAttachmentRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaAssetRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowConfigurationRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowJobRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamCdnConfigRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamPackagingConfigRequest;
import com.oracle.bmc.mediaservices.responses.GetMediaAssetDistributionChannelAttachmentResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaAssetResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowConfigurationResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowJobResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamCdnConfigResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamPackagingConfigResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class MediaServicesWaiters {
    private final ExecutorService executorService;
    private final MediaServices client;

    public MediaServicesWaiters(ExecutorService executorService, MediaServices client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetMediaAssetRequest, GetMediaAssetResponse> forMediaAsset(GetMediaAssetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMediaAssetRequest, GetMediaAssetResponse> forMediaAsset(GetMediaAssetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMediaAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMediaAssetRequest, GetMediaAssetResponse> forMediaAsset(GetMediaAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMediaAssetRequest, GetMediaAssetResponse> forMediaAsset(BmcGenericWaiter waiter, GetMediaAssetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMediaAssetRequest, GetMediaAssetResponse>(){

            @Override
            public GetMediaAssetResponse apply(GetMediaAssetRequest request) {
                return MediaServicesWaiters.this.client.getMediaAsset(request);
            }
        }, (Predicate)new Predicate<GetMediaAssetResponse>(){

            @Override
            public boolean test(GetMediaAssetResponse response) {
                return targetStatesSet.contains((Object)response.getMediaAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMediaAssetDistributionChannelAttachmentRequest, GetMediaAssetDistributionChannelAttachmentResponse> forMediaAssetDistributionChannelAttachment(GetMediaAssetDistributionChannelAttachmentRequest request, MediaAssetDistributionChannelAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaAssetDistributionChannelAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMediaAssetDistributionChannelAttachmentRequest, GetMediaAssetDistributionChannelAttachmentResponse> forMediaAssetDistributionChannelAttachment(GetMediaAssetDistributionChannelAttachmentRequest request, MediaAssetDistributionChannelAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMediaAssetDistributionChannelAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMediaAssetDistributionChannelAttachmentRequest, GetMediaAssetDistributionChannelAttachmentResponse> forMediaAssetDistributionChannelAttachment(GetMediaAssetDistributionChannelAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MediaAssetDistributionChannelAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMediaAssetDistributionChannelAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMediaAssetDistributionChannelAttachmentRequest, GetMediaAssetDistributionChannelAttachmentResponse> forMediaAssetDistributionChannelAttachment(BmcGenericWaiter waiter, GetMediaAssetDistributionChannelAttachmentRequest request, MediaAssetDistributionChannelAttachment.LifecycleState ... targetStates) {
        final HashSet<MediaAssetDistributionChannelAttachment.LifecycleState> targetStatesSet = new HashSet<MediaAssetDistributionChannelAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMediaAssetDistributionChannelAttachmentRequest, GetMediaAssetDistributionChannelAttachmentResponse>(){

            @Override
            public GetMediaAssetDistributionChannelAttachmentResponse apply(GetMediaAssetDistributionChannelAttachmentRequest request) {
                return MediaServicesWaiters.this.client.getMediaAssetDistributionChannelAttachment(request);
            }
        }, (Predicate)new Predicate<GetMediaAssetDistributionChannelAttachmentResponse>(){

            @Override
            public boolean test(GetMediaAssetDistributionChannelAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getMediaAssetDistributionChannelAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetMediaWorkflowRequest, GetMediaWorkflowResponse> forMediaWorkflow(GetMediaWorkflowRequest request, MediaWorkflow.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflow(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMediaWorkflowRequest, GetMediaWorkflowResponse> forMediaWorkflow(GetMediaWorkflowRequest request, MediaWorkflow.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMediaWorkflow(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMediaWorkflowRequest, GetMediaWorkflowResponse> forMediaWorkflow(GetMediaWorkflowRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MediaWorkflow.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflow(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMediaWorkflowRequest, GetMediaWorkflowResponse> forMediaWorkflow(BmcGenericWaiter waiter, GetMediaWorkflowRequest request, MediaWorkflow.LifecycleState ... targetStates) {
        final HashSet<MediaWorkflow.LifecycleState> targetStatesSet = new HashSet<MediaWorkflow.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMediaWorkflowRequest, GetMediaWorkflowResponse>(){

            @Override
            public GetMediaWorkflowResponse apply(GetMediaWorkflowRequest request) {
                return MediaServicesWaiters.this.client.getMediaWorkflow(request);
            }
        }, (Predicate)new Predicate<GetMediaWorkflowResponse>(){

            @Override
            public boolean test(GetMediaWorkflowResponse response) {
                return targetStatesSet.contains((Object)response.getMediaWorkflow().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MediaWorkflow.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMediaWorkflowConfigurationRequest, GetMediaWorkflowConfigurationResponse> forMediaWorkflowConfiguration(GetMediaWorkflowConfigurationRequest request, MediaWorkflowConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflowConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMediaWorkflowConfigurationRequest, GetMediaWorkflowConfigurationResponse> forMediaWorkflowConfiguration(GetMediaWorkflowConfigurationRequest request, MediaWorkflowConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMediaWorkflowConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMediaWorkflowConfigurationRequest, GetMediaWorkflowConfigurationResponse> forMediaWorkflowConfiguration(GetMediaWorkflowConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MediaWorkflowConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflowConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMediaWorkflowConfigurationRequest, GetMediaWorkflowConfigurationResponse> forMediaWorkflowConfiguration(BmcGenericWaiter waiter, GetMediaWorkflowConfigurationRequest request, MediaWorkflowConfiguration.LifecycleState ... targetStates) {
        final HashSet<MediaWorkflowConfiguration.LifecycleState> targetStatesSet = new HashSet<MediaWorkflowConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMediaWorkflowConfigurationRequest, GetMediaWorkflowConfigurationResponse>(){

            @Override
            public GetMediaWorkflowConfigurationResponse apply(GetMediaWorkflowConfigurationRequest request) {
                return MediaServicesWaiters.this.client.getMediaWorkflowConfiguration(request);
            }
        }, (Predicate)new Predicate<GetMediaWorkflowConfigurationResponse>(){

            @Override
            public boolean test(GetMediaWorkflowConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getMediaWorkflowConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MediaWorkflowConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMediaWorkflowJobRequest, GetMediaWorkflowJobResponse> forMediaWorkflowJob(GetMediaWorkflowJobRequest request, MediaWorkflowJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflowJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMediaWorkflowJobRequest, GetMediaWorkflowJobResponse> forMediaWorkflowJob(GetMediaWorkflowJobRequest request, MediaWorkflowJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMediaWorkflowJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMediaWorkflowJobRequest, GetMediaWorkflowJobResponse> forMediaWorkflowJob(GetMediaWorkflowJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MediaWorkflowJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMediaWorkflowJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMediaWorkflowJobRequest, GetMediaWorkflowJobResponse> forMediaWorkflowJob(BmcGenericWaiter waiter, GetMediaWorkflowJobRequest request, MediaWorkflowJob.LifecycleState ... targetStates) {
        final HashSet<MediaWorkflowJob.LifecycleState> targetStatesSet = new HashSet<MediaWorkflowJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMediaWorkflowJobRequest, GetMediaWorkflowJobResponse>(){

            @Override
            public GetMediaWorkflowJobResponse apply(GetMediaWorkflowJobRequest request) {
                return MediaServicesWaiters.this.client.getMediaWorkflowJob(request);
            }
        }, (Predicate)new Predicate<GetMediaWorkflowJobResponse>(){

            @Override
            public boolean test(GetMediaWorkflowJobResponse response) {
                return targetStatesSet.contains((Object)response.getMediaWorkflowJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetStreamCdnConfigRequest, GetStreamCdnConfigResponse> forStreamCdnConfig(GetStreamCdnConfigRequest request, StreamCdnConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStreamCdnConfig(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamCdnConfigRequest, GetStreamCdnConfigResponse> forStreamCdnConfig(GetStreamCdnConfigRequest request, StreamCdnConfig.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStreamCdnConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStreamCdnConfigRequest, GetStreamCdnConfigResponse> forStreamCdnConfig(GetStreamCdnConfigRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, StreamCdnConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStreamCdnConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamCdnConfigRequest, GetStreamCdnConfigResponse> forStreamCdnConfig(BmcGenericWaiter waiter, GetStreamCdnConfigRequest request, StreamCdnConfig.LifecycleState ... targetStates) {
        final HashSet<StreamCdnConfig.LifecycleState> targetStatesSet = new HashSet<StreamCdnConfig.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStreamCdnConfigRequest, GetStreamCdnConfigResponse>(){

            @Override
            public GetStreamCdnConfigResponse apply(GetStreamCdnConfigRequest request) {
                return MediaServicesWaiters.this.client.getStreamCdnConfig(request);
            }
        }, (Predicate)new Predicate<GetStreamCdnConfigResponse>(){

            @Override
            public boolean test(GetStreamCdnConfigResponse response) {
                return targetStatesSet.contains((Object)response.getStreamCdnConfig().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)StreamCdnConfig.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStreamDistributionChannelRequest, GetStreamDistributionChannelResponse> forStreamDistributionChannel(GetStreamDistributionChannelRequest request, StreamDistributionChannel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStreamDistributionChannel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamDistributionChannelRequest, GetStreamDistributionChannelResponse> forStreamDistributionChannel(GetStreamDistributionChannelRequest request, StreamDistributionChannel.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStreamDistributionChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStreamDistributionChannelRequest, GetStreamDistributionChannelResponse> forStreamDistributionChannel(GetStreamDistributionChannelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, StreamDistributionChannel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStreamDistributionChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamDistributionChannelRequest, GetStreamDistributionChannelResponse> forStreamDistributionChannel(BmcGenericWaiter waiter, GetStreamDistributionChannelRequest request, StreamDistributionChannel.LifecycleState ... targetStates) {
        final HashSet<StreamDistributionChannel.LifecycleState> targetStatesSet = new HashSet<StreamDistributionChannel.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStreamDistributionChannelRequest, GetStreamDistributionChannelResponse>(){

            @Override
            public GetStreamDistributionChannelResponse apply(GetStreamDistributionChannelRequest request) {
                return MediaServicesWaiters.this.client.getStreamDistributionChannel(request);
            }
        }, (Predicate)new Predicate<GetStreamDistributionChannelResponse>(){

            @Override
            public boolean test(GetStreamDistributionChannelResponse response) {
                return targetStatesSet.contains((Object)response.getStreamDistributionChannel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)StreamDistributionChannel.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStreamPackagingConfigRequest, GetStreamPackagingConfigResponse> forStreamPackagingConfig(GetStreamPackagingConfigRequest request, StreamPackagingConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStreamPackagingConfig(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamPackagingConfigRequest, GetStreamPackagingConfigResponse> forStreamPackagingConfig(GetStreamPackagingConfigRequest request, StreamPackagingConfig.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStreamPackagingConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStreamPackagingConfigRequest, GetStreamPackagingConfigResponse> forStreamPackagingConfig(GetStreamPackagingConfigRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, StreamPackagingConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStreamPackagingConfig(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamPackagingConfigRequest, GetStreamPackagingConfigResponse> forStreamPackagingConfig(BmcGenericWaiter waiter, GetStreamPackagingConfigRequest request, StreamPackagingConfig.LifecycleState ... targetStates) {
        final HashSet<StreamPackagingConfig.LifecycleState> targetStatesSet = new HashSet<StreamPackagingConfig.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStreamPackagingConfigRequest, GetStreamPackagingConfigResponse>(){

            @Override
            public GetStreamPackagingConfigResponse apply(GetStreamPackagingConfigRequest request) {
                return MediaServicesWaiters.this.client.getStreamPackagingConfig(request);
            }
        }, (Predicate)new Predicate<GetStreamPackagingConfigResponse>(){

            @Override
            public boolean test(GetStreamPackagingConfigResponse response) {
                return targetStatesSet.contains((Object)response.getStreamPackagingConfig().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)StreamPackagingConfig.LifecycleState.Deleted)), (Object)request);
    }
}

