/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices;

import com.oracle.bmc.mediaservices.MediaServices;
import com.oracle.bmc.mediaservices.model.MediaAssetDistributionChannelAttachmentSummary;
import com.oracle.bmc.mediaservices.model.MediaAssetSummary;
import com.oracle.bmc.mediaservices.model.MediaWorkflowConfigurationSummary;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobFactSummary;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobSummary;
import com.oracle.bmc.mediaservices.model.MediaWorkflowSummary;
import com.oracle.bmc.mediaservices.model.MediaWorkflowTaskDeclaration;
import com.oracle.bmc.mediaservices.model.StreamCdnConfigSummary;
import com.oracle.bmc.mediaservices.model.StreamDistributionChannelSummary;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfigSummary;
import com.oracle.bmc.mediaservices.model.SystemMediaWorkflow;
import com.oracle.bmc.mediaservices.requests.ListMediaAssetDistributionChannelAttachmentsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaAssetsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowConfigurationsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowJobFactsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowJobsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowTaskDeclarationsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamCdnConfigsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamDistributionChannelsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamPackagingConfigsRequest;
import com.oracle.bmc.mediaservices.requests.ListSystemMediaWorkflowsRequest;
import com.oracle.bmc.mediaservices.responses.ListMediaAssetDistributionChannelAttachmentsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaAssetsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowConfigurationsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowJobFactsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowJobsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowTaskDeclarationsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamCdnConfigsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamDistributionChannelsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamPackagingConfigsResponse;
import com.oracle.bmc.mediaservices.responses.ListSystemMediaWorkflowsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MediaServicesPaginators {
    private final MediaServices client;

    public MediaServicesPaginators(MediaServices client) {
        this.client = client;
    }

    public Iterable<ListMediaAssetDistributionChannelAttachmentsResponse> listMediaAssetDistributionChannelAttachmentsResponseIterator(final ListMediaAssetDistributionChannelAttachmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaAssetDistributionChannelAttachmentsRequest.Builder>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsRequest.Builder get() {
                return ListMediaAssetDistributionChannelAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaAssetDistributionChannelAttachmentsResponse, String>(){

            @Override
            public String apply(ListMediaAssetDistributionChannelAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaAssetDistributionChannelAttachmentsRequest.Builder>, ListMediaAssetDistributionChannelAttachmentsRequest>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsRequest apply(RequestBuilderAndToken<ListMediaAssetDistributionChannelAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaAssetDistributionChannelAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaAssetDistributionChannelAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaAssetDistributionChannelAttachmentsRequest, ListMediaAssetDistributionChannelAttachmentsResponse>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsResponse apply(ListMediaAssetDistributionChannelAttachmentsRequest request) {
                return MediaServicesPaginators.this.client.listMediaAssetDistributionChannelAttachments(request);
            }
        });
    }

    public Iterable<MediaAssetDistributionChannelAttachmentSummary> listMediaAssetDistributionChannelAttachmentsRecordIterator(final ListMediaAssetDistributionChannelAttachmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaAssetDistributionChannelAttachmentsRequest.Builder>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsRequest.Builder get() {
                return ListMediaAssetDistributionChannelAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaAssetDistributionChannelAttachmentsResponse, String>(){

            @Override
            public String apply(ListMediaAssetDistributionChannelAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaAssetDistributionChannelAttachmentsRequest.Builder>, ListMediaAssetDistributionChannelAttachmentsRequest>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsRequest apply(RequestBuilderAndToken<ListMediaAssetDistributionChannelAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaAssetDistributionChannelAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaAssetDistributionChannelAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaAssetDistributionChannelAttachmentsRequest, ListMediaAssetDistributionChannelAttachmentsResponse>(){

            @Override
            public ListMediaAssetDistributionChannelAttachmentsResponse apply(ListMediaAssetDistributionChannelAttachmentsRequest request) {
                return MediaServicesPaginators.this.client.listMediaAssetDistributionChannelAttachments(request);
            }
        }, (Function)new Function<ListMediaAssetDistributionChannelAttachmentsResponse, List<MediaAssetDistributionChannelAttachmentSummary>>(){

            @Override
            public List<MediaAssetDistributionChannelAttachmentSummary> apply(ListMediaAssetDistributionChannelAttachmentsResponse response) {
                return response.getMediaAssetDistributionChannelAttachmentCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaAssetsResponse> listMediaAssetsResponseIterator(final ListMediaAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaAssetsRequest.Builder>(){

            @Override
            public ListMediaAssetsRequest.Builder get() {
                return ListMediaAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaAssetsResponse, String>(){

            @Override
            public String apply(ListMediaAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaAssetsRequest.Builder>, ListMediaAssetsRequest>(){

            @Override
            public ListMediaAssetsRequest apply(RequestBuilderAndToken<ListMediaAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaAssetsRequest, ListMediaAssetsResponse>(){

            @Override
            public ListMediaAssetsResponse apply(ListMediaAssetsRequest request) {
                return MediaServicesPaginators.this.client.listMediaAssets(request);
            }
        });
    }

    public Iterable<MediaAssetSummary> listMediaAssetsRecordIterator(final ListMediaAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaAssetsRequest.Builder>(){

            @Override
            public ListMediaAssetsRequest.Builder get() {
                return ListMediaAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaAssetsResponse, String>(){

            @Override
            public String apply(ListMediaAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaAssetsRequest.Builder>, ListMediaAssetsRequest>(){

            @Override
            public ListMediaAssetsRequest apply(RequestBuilderAndToken<ListMediaAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaAssetsRequest, ListMediaAssetsResponse>(){

            @Override
            public ListMediaAssetsResponse apply(ListMediaAssetsRequest request) {
                return MediaServicesPaginators.this.client.listMediaAssets(request);
            }
        }, (Function)new Function<ListMediaAssetsResponse, List<MediaAssetSummary>>(){

            @Override
            public List<MediaAssetSummary> apply(ListMediaAssetsResponse response) {
                return response.getMediaAssetCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaWorkflowConfigurationsResponse> listMediaWorkflowConfigurationsResponseIterator(final ListMediaWorkflowConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaWorkflowConfigurationsRequest.Builder>(){

            @Override
            public ListMediaWorkflowConfigurationsRequest.Builder get() {
                return ListMediaWorkflowConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowConfigurationsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowConfigurationsRequest.Builder>, ListMediaWorkflowConfigurationsRequest>(){

            @Override
            public ListMediaWorkflowConfigurationsRequest apply(RequestBuilderAndToken<ListMediaWorkflowConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowConfigurationsRequest, ListMediaWorkflowConfigurationsResponse>(){

            @Override
            public ListMediaWorkflowConfigurationsResponse apply(ListMediaWorkflowConfigurationsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowConfigurations(request);
            }
        });
    }

    public Iterable<MediaWorkflowConfigurationSummary> listMediaWorkflowConfigurationsRecordIterator(final ListMediaWorkflowConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaWorkflowConfigurationsRequest.Builder>(){

            @Override
            public ListMediaWorkflowConfigurationsRequest.Builder get() {
                return ListMediaWorkflowConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowConfigurationsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowConfigurationsRequest.Builder>, ListMediaWorkflowConfigurationsRequest>(){

            @Override
            public ListMediaWorkflowConfigurationsRequest apply(RequestBuilderAndToken<ListMediaWorkflowConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowConfigurationsRequest, ListMediaWorkflowConfigurationsResponse>(){

            @Override
            public ListMediaWorkflowConfigurationsResponse apply(ListMediaWorkflowConfigurationsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowConfigurations(request);
            }
        }, (Function)new Function<ListMediaWorkflowConfigurationsResponse, List<MediaWorkflowConfigurationSummary>>(){

            @Override
            public List<MediaWorkflowConfigurationSummary> apply(ListMediaWorkflowConfigurationsResponse response) {
                return response.getMediaWorkflowConfigurationCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaWorkflowJobFactsResponse> listMediaWorkflowJobFactsResponseIterator(final ListMediaWorkflowJobFactsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaWorkflowJobFactsRequest.Builder>(){

            @Override
            public ListMediaWorkflowJobFactsRequest.Builder get() {
                return ListMediaWorkflowJobFactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobFactsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowJobFactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowJobFactsRequest.Builder>, ListMediaWorkflowJobFactsRequest>(){

            @Override
            public ListMediaWorkflowJobFactsRequest apply(RequestBuilderAndToken<ListMediaWorkflowJobFactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowJobFactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowJobFactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowJobFactsRequest, ListMediaWorkflowJobFactsResponse>(){

            @Override
            public ListMediaWorkflowJobFactsResponse apply(ListMediaWorkflowJobFactsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowJobFacts(request);
            }
        });
    }

    public Iterable<MediaWorkflowJobFactSummary> listMediaWorkflowJobFactsRecordIterator(final ListMediaWorkflowJobFactsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaWorkflowJobFactsRequest.Builder>(){

            @Override
            public ListMediaWorkflowJobFactsRequest.Builder get() {
                return ListMediaWorkflowJobFactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobFactsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowJobFactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowJobFactsRequest.Builder>, ListMediaWorkflowJobFactsRequest>(){

            @Override
            public ListMediaWorkflowJobFactsRequest apply(RequestBuilderAndToken<ListMediaWorkflowJobFactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowJobFactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowJobFactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowJobFactsRequest, ListMediaWorkflowJobFactsResponse>(){

            @Override
            public ListMediaWorkflowJobFactsResponse apply(ListMediaWorkflowJobFactsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowJobFacts(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobFactsResponse, List<MediaWorkflowJobFactSummary>>(){

            @Override
            public List<MediaWorkflowJobFactSummary> apply(ListMediaWorkflowJobFactsResponse response) {
                return response.getMediaWorkflowJobFactCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaWorkflowJobsResponse> listMediaWorkflowJobsResponseIterator(final ListMediaWorkflowJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaWorkflowJobsRequest.Builder>(){

            @Override
            public ListMediaWorkflowJobsRequest.Builder get() {
                return ListMediaWorkflowJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowJobsRequest.Builder>, ListMediaWorkflowJobsRequest>(){

            @Override
            public ListMediaWorkflowJobsRequest apply(RequestBuilderAndToken<ListMediaWorkflowJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowJobsRequest, ListMediaWorkflowJobsResponse>(){

            @Override
            public ListMediaWorkflowJobsResponse apply(ListMediaWorkflowJobsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowJobs(request);
            }
        });
    }

    public Iterable<MediaWorkflowJobSummary> listMediaWorkflowJobsRecordIterator(final ListMediaWorkflowJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaWorkflowJobsRequest.Builder>(){

            @Override
            public ListMediaWorkflowJobsRequest.Builder get() {
                return ListMediaWorkflowJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowJobsRequest.Builder>, ListMediaWorkflowJobsRequest>(){

            @Override
            public ListMediaWorkflowJobsRequest apply(RequestBuilderAndToken<ListMediaWorkflowJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowJobsRequest, ListMediaWorkflowJobsResponse>(){

            @Override
            public ListMediaWorkflowJobsResponse apply(ListMediaWorkflowJobsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowJobs(request);
            }
        }, (Function)new Function<ListMediaWorkflowJobsResponse, List<MediaWorkflowJobSummary>>(){

            @Override
            public List<MediaWorkflowJobSummary> apply(ListMediaWorkflowJobsResponse response) {
                return response.getMediaWorkflowJobCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaWorkflowTaskDeclarationsResponse> listMediaWorkflowTaskDeclarationsResponseIterator(final ListMediaWorkflowTaskDeclarationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaWorkflowTaskDeclarationsRequest.Builder>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsRequest.Builder get() {
                return ListMediaWorkflowTaskDeclarationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowTaskDeclarationsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowTaskDeclarationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowTaskDeclarationsRequest.Builder>, ListMediaWorkflowTaskDeclarationsRequest>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsRequest apply(RequestBuilderAndToken<ListMediaWorkflowTaskDeclarationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowTaskDeclarationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowTaskDeclarationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowTaskDeclarationsRequest, ListMediaWorkflowTaskDeclarationsResponse>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsResponse apply(ListMediaWorkflowTaskDeclarationsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowTaskDeclarations(request);
            }
        });
    }

    public Iterable<MediaWorkflowTaskDeclaration> listMediaWorkflowTaskDeclarationsRecordIterator(final ListMediaWorkflowTaskDeclarationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaWorkflowTaskDeclarationsRequest.Builder>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsRequest.Builder get() {
                return ListMediaWorkflowTaskDeclarationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowTaskDeclarationsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowTaskDeclarationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowTaskDeclarationsRequest.Builder>, ListMediaWorkflowTaskDeclarationsRequest>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsRequest apply(RequestBuilderAndToken<ListMediaWorkflowTaskDeclarationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowTaskDeclarationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowTaskDeclarationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowTaskDeclarationsRequest, ListMediaWorkflowTaskDeclarationsResponse>(){

            @Override
            public ListMediaWorkflowTaskDeclarationsResponse apply(ListMediaWorkflowTaskDeclarationsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflowTaskDeclarations(request);
            }
        }, (Function)new Function<ListMediaWorkflowTaskDeclarationsResponse, List<MediaWorkflowTaskDeclaration>>(){

            @Override
            public List<MediaWorkflowTaskDeclaration> apply(ListMediaWorkflowTaskDeclarationsResponse response) {
                return response.getMediaWorkflowTaskDeclarationCollection().getItems();
            }
        });
    }

    public Iterable<ListMediaWorkflowsResponse> listMediaWorkflowsResponseIterator(final ListMediaWorkflowsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMediaWorkflowsRequest.Builder>(){

            @Override
            public ListMediaWorkflowsRequest.Builder get() {
                return ListMediaWorkflowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowsRequest.Builder>, ListMediaWorkflowsRequest>(){

            @Override
            public ListMediaWorkflowsRequest apply(RequestBuilderAndToken<ListMediaWorkflowsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowsRequest, ListMediaWorkflowsResponse>(){

            @Override
            public ListMediaWorkflowsResponse apply(ListMediaWorkflowsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflows(request);
            }
        });
    }

    public Iterable<MediaWorkflowSummary> listMediaWorkflowsRecordIterator(final ListMediaWorkflowsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMediaWorkflowsRequest.Builder>(){

            @Override
            public ListMediaWorkflowsRequest.Builder get() {
                return ListMediaWorkflowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMediaWorkflowsResponse, String>(){

            @Override
            public String apply(ListMediaWorkflowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMediaWorkflowsRequest.Builder>, ListMediaWorkflowsRequest>(){

            @Override
            public ListMediaWorkflowsRequest apply(RequestBuilderAndToken<ListMediaWorkflowsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMediaWorkflowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMediaWorkflowsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMediaWorkflowsRequest, ListMediaWorkflowsResponse>(){

            @Override
            public ListMediaWorkflowsResponse apply(ListMediaWorkflowsRequest request) {
                return MediaServicesPaginators.this.client.listMediaWorkflows(request);
            }
        }, (Function)new Function<ListMediaWorkflowsResponse, List<MediaWorkflowSummary>>(){

            @Override
            public List<MediaWorkflowSummary> apply(ListMediaWorkflowsResponse response) {
                return response.getMediaWorkflowCollection().getItems();
            }
        });
    }

    public Iterable<ListStreamCdnConfigsResponse> listStreamCdnConfigsResponseIterator(final ListStreamCdnConfigsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStreamCdnConfigsRequest.Builder>(){

            @Override
            public ListStreamCdnConfigsRequest.Builder get() {
                return ListStreamCdnConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamCdnConfigsResponse, String>(){

            @Override
            public String apply(ListStreamCdnConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamCdnConfigsRequest.Builder>, ListStreamCdnConfigsRequest>(){

            @Override
            public ListStreamCdnConfigsRequest apply(RequestBuilderAndToken<ListStreamCdnConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamCdnConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamCdnConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamCdnConfigsRequest, ListStreamCdnConfigsResponse>(){

            @Override
            public ListStreamCdnConfigsResponse apply(ListStreamCdnConfigsRequest request) {
                return MediaServicesPaginators.this.client.listStreamCdnConfigs(request);
            }
        });
    }

    public Iterable<StreamCdnConfigSummary> listStreamCdnConfigsRecordIterator(final ListStreamCdnConfigsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStreamCdnConfigsRequest.Builder>(){

            @Override
            public ListStreamCdnConfigsRequest.Builder get() {
                return ListStreamCdnConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamCdnConfigsResponse, String>(){

            @Override
            public String apply(ListStreamCdnConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamCdnConfigsRequest.Builder>, ListStreamCdnConfigsRequest>(){

            @Override
            public ListStreamCdnConfigsRequest apply(RequestBuilderAndToken<ListStreamCdnConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamCdnConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamCdnConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamCdnConfigsRequest, ListStreamCdnConfigsResponse>(){

            @Override
            public ListStreamCdnConfigsResponse apply(ListStreamCdnConfigsRequest request) {
                return MediaServicesPaginators.this.client.listStreamCdnConfigs(request);
            }
        }, (Function)new Function<ListStreamCdnConfigsResponse, List<StreamCdnConfigSummary>>(){

            @Override
            public List<StreamCdnConfigSummary> apply(ListStreamCdnConfigsResponse response) {
                return response.getStreamCdnConfigCollection().getItems();
            }
        });
    }

    public Iterable<ListStreamDistributionChannelsResponse> listStreamDistributionChannelsResponseIterator(final ListStreamDistributionChannelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStreamDistributionChannelsRequest.Builder>(){

            @Override
            public ListStreamDistributionChannelsRequest.Builder get() {
                return ListStreamDistributionChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamDistributionChannelsResponse, String>(){

            @Override
            public String apply(ListStreamDistributionChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamDistributionChannelsRequest.Builder>, ListStreamDistributionChannelsRequest>(){

            @Override
            public ListStreamDistributionChannelsRequest apply(RequestBuilderAndToken<ListStreamDistributionChannelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamDistributionChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamDistributionChannelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamDistributionChannelsRequest, ListStreamDistributionChannelsResponse>(){

            @Override
            public ListStreamDistributionChannelsResponse apply(ListStreamDistributionChannelsRequest request) {
                return MediaServicesPaginators.this.client.listStreamDistributionChannels(request);
            }
        });
    }

    public Iterable<StreamDistributionChannelSummary> listStreamDistributionChannelsRecordIterator(final ListStreamDistributionChannelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStreamDistributionChannelsRequest.Builder>(){

            @Override
            public ListStreamDistributionChannelsRequest.Builder get() {
                return ListStreamDistributionChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamDistributionChannelsResponse, String>(){

            @Override
            public String apply(ListStreamDistributionChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamDistributionChannelsRequest.Builder>, ListStreamDistributionChannelsRequest>(){

            @Override
            public ListStreamDistributionChannelsRequest apply(RequestBuilderAndToken<ListStreamDistributionChannelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamDistributionChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamDistributionChannelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamDistributionChannelsRequest, ListStreamDistributionChannelsResponse>(){

            @Override
            public ListStreamDistributionChannelsResponse apply(ListStreamDistributionChannelsRequest request) {
                return MediaServicesPaginators.this.client.listStreamDistributionChannels(request);
            }
        }, (Function)new Function<ListStreamDistributionChannelsResponse, List<StreamDistributionChannelSummary>>(){

            @Override
            public List<StreamDistributionChannelSummary> apply(ListStreamDistributionChannelsResponse response) {
                return response.getStreamDistributionChannelCollection().getItems();
            }
        });
    }

    public Iterable<ListStreamPackagingConfigsResponse> listStreamPackagingConfigsResponseIterator(final ListStreamPackagingConfigsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStreamPackagingConfigsRequest.Builder>(){

            @Override
            public ListStreamPackagingConfigsRequest.Builder get() {
                return ListStreamPackagingConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamPackagingConfigsResponse, String>(){

            @Override
            public String apply(ListStreamPackagingConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamPackagingConfigsRequest.Builder>, ListStreamPackagingConfigsRequest>(){

            @Override
            public ListStreamPackagingConfigsRequest apply(RequestBuilderAndToken<ListStreamPackagingConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamPackagingConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamPackagingConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamPackagingConfigsRequest, ListStreamPackagingConfigsResponse>(){

            @Override
            public ListStreamPackagingConfigsResponse apply(ListStreamPackagingConfigsRequest request) {
                return MediaServicesPaginators.this.client.listStreamPackagingConfigs(request);
            }
        });
    }

    public Iterable<StreamPackagingConfigSummary> listStreamPackagingConfigsRecordIterator(final ListStreamPackagingConfigsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStreamPackagingConfigsRequest.Builder>(){

            @Override
            public ListStreamPackagingConfigsRequest.Builder get() {
                return ListStreamPackagingConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamPackagingConfigsResponse, String>(){

            @Override
            public String apply(ListStreamPackagingConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamPackagingConfigsRequest.Builder>, ListStreamPackagingConfigsRequest>(){

            @Override
            public ListStreamPackagingConfigsRequest apply(RequestBuilderAndToken<ListStreamPackagingConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamPackagingConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamPackagingConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamPackagingConfigsRequest, ListStreamPackagingConfigsResponse>(){

            @Override
            public ListStreamPackagingConfigsResponse apply(ListStreamPackagingConfigsRequest request) {
                return MediaServicesPaginators.this.client.listStreamPackagingConfigs(request);
            }
        }, (Function)new Function<ListStreamPackagingConfigsResponse, List<StreamPackagingConfigSummary>>(){

            @Override
            public List<StreamPackagingConfigSummary> apply(ListStreamPackagingConfigsResponse response) {
                return response.getStreamPackagingConfigCollection().getItems();
            }
        });
    }

    public Iterable<ListSystemMediaWorkflowsResponse> listSystemMediaWorkflowsResponseIterator(final ListSystemMediaWorkflowsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSystemMediaWorkflowsRequest.Builder>(){

            @Override
            public ListSystemMediaWorkflowsRequest.Builder get() {
                return ListSystemMediaWorkflowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSystemMediaWorkflowsResponse, String>(){

            @Override
            public String apply(ListSystemMediaWorkflowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSystemMediaWorkflowsRequest.Builder>, ListSystemMediaWorkflowsRequest>(){

            @Override
            public ListSystemMediaWorkflowsRequest apply(RequestBuilderAndToken<ListSystemMediaWorkflowsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSystemMediaWorkflowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSystemMediaWorkflowsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSystemMediaWorkflowsRequest, ListSystemMediaWorkflowsResponse>(){

            @Override
            public ListSystemMediaWorkflowsResponse apply(ListSystemMediaWorkflowsRequest request) {
                return MediaServicesPaginators.this.client.listSystemMediaWorkflows(request);
            }
        });
    }

    public Iterable<SystemMediaWorkflow> listSystemMediaWorkflowsRecordIterator(final ListSystemMediaWorkflowsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSystemMediaWorkflowsRequest.Builder>(){

            @Override
            public ListSystemMediaWorkflowsRequest.Builder get() {
                return ListSystemMediaWorkflowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSystemMediaWorkflowsResponse, String>(){

            @Override
            public String apply(ListSystemMediaWorkflowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSystemMediaWorkflowsRequest.Builder>, ListSystemMediaWorkflowsRequest>(){

            @Override
            public ListSystemMediaWorkflowsRequest apply(RequestBuilderAndToken<ListSystemMediaWorkflowsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSystemMediaWorkflowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSystemMediaWorkflowsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSystemMediaWorkflowsRequest, ListSystemMediaWorkflowsResponse>(){

            @Override
            public ListSystemMediaWorkflowsResponse apply(ListSystemMediaWorkflowsRequest request) {
                return MediaServicesPaginators.this.client.listSystemMediaWorkflows(request);
            }
        }, (Function)new Function<ListSystemMediaWorkflowsResponse, List<SystemMediaWorkflow>>(){

            @Override
            public List<SystemMediaWorkflow> apply(ListSystemMediaWorkflowsResponse response) {
                return response.getSystemMediaWorkflowCollection().getItems();
            }
        });
    }
}

