/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagementDashboardTileDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="savedSearchId")
    private final String savedSearchId;
    @JsonProperty(value="row")
    private final Integer row;
    @JsonProperty(value="column")
    private final Integer column;
    @JsonProperty(value="height")
    private final Integer height;
    @JsonProperty(value="width")
    private final Integer width;
    @JsonProperty(value="nls")
    private final Object nls;
    @JsonProperty(value="uiConfig")
    private final Object uiConfig;
    @JsonProperty(value="dataConfig")
    private final List<Object> dataConfig;
    @JsonProperty(value="state")
    private final State state;
    @JsonProperty(value="drilldownConfig")
    private final Object drilldownConfig;
    @JsonProperty(value="parametersMap")
    private final Object parametersMap;

    @Deprecated
    @ConstructorProperties(value={"displayName", "savedSearchId", "row", "column", "height", "width", "nls", "uiConfig", "dataConfig", "state", "drilldownConfig", "parametersMap"})
    public ManagementDashboardTileDetails(String displayName, String savedSearchId, Integer row, Integer column, Integer height, Integer width, Object nls, Object uiConfig, List<Object> dataConfig, State state, Object drilldownConfig, Object parametersMap) {
        this.displayName = displayName;
        this.savedSearchId = savedSearchId;
        this.row = row;
        this.column = column;
        this.height = height;
        this.width = width;
        this.nls = nls;
        this.uiConfig = uiConfig;
        this.dataConfig = dataConfig;
        this.state = state;
        this.drilldownConfig = drilldownConfig;
        this.parametersMap = parametersMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSavedSearchId() {
        return this.savedSearchId;
    }

    public Integer getRow() {
        return this.row;
    }

    public Integer getColumn() {
        return this.column;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Object getNls() {
        return this.nls;
    }

    public Object getUiConfig() {
        return this.uiConfig;
    }

    public List<Object> getDataConfig() {
        return this.dataConfig;
    }

    public State getState() {
        return this.state;
    }

    public Object getDrilldownConfig() {
        return this.drilldownConfig;
    }

    public Object getParametersMap() {
        return this.parametersMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagementDashboardTileDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", savedSearchId=").append(String.valueOf(this.savedSearchId));
        sb.append(", row=").append(String.valueOf(this.row));
        sb.append(", column=").append(String.valueOf(this.column));
        sb.append(", height=").append(String.valueOf(this.height));
        sb.append(", width=").append(String.valueOf(this.width));
        sb.append(", nls=").append(String.valueOf(this.nls));
        sb.append(", uiConfig=").append(String.valueOf(this.uiConfig));
        sb.append(", dataConfig=").append(String.valueOf(this.dataConfig));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", drilldownConfig=").append(String.valueOf(this.drilldownConfig));
        sb.append(", parametersMap=").append(String.valueOf(this.parametersMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagementDashboardTileDetails)) {
            return false;
        }
        ManagementDashboardTileDetails other = (ManagementDashboardTileDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.savedSearchId, other.savedSearchId) && Objects.equals(this.row, other.row) && Objects.equals(this.column, other.column) && Objects.equals(this.height, other.height) && Objects.equals(this.width, other.width) && Objects.equals(this.nls, other.nls) && Objects.equals(this.uiConfig, other.uiConfig) && Objects.equals(this.dataConfig, other.dataConfig) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.drilldownConfig, other.drilldownConfig) && Objects.equals(this.parametersMap, other.parametersMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.savedSearchId == null ? 43 : this.savedSearchId.hashCode());
        result = result * 59 + (this.row == null ? 43 : this.row.hashCode());
        result = result * 59 + (this.column == null ? 43 : this.column.hashCode());
        result = result * 59 + (this.height == null ? 43 : this.height.hashCode());
        result = result * 59 + (this.width == null ? 43 : this.width.hashCode());
        result = result * 59 + (this.nls == null ? 43 : this.nls.hashCode());
        result = result * 59 + (this.uiConfig == null ? 43 : this.uiConfig.hashCode());
        result = result * 59 + (this.dataConfig == null ? 43 : this.dataConfig.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.drilldownConfig == null ? 43 : this.drilldownConfig.hashCode());
        result = result * 59 + (this.parametersMap == null ? 43 : this.parametersMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum State implements BmcEnum
    {
        Deleted("DELETED"),
        Unauthorized("UNAUTHORIZED"),
        Default("DEFAULT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'State', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(State.class);
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="savedSearchId")
        private String savedSearchId;
        @JsonProperty(value="row")
        private Integer row;
        @JsonProperty(value="column")
        private Integer column;
        @JsonProperty(value="height")
        private Integer height;
        @JsonProperty(value="width")
        private Integer width;
        @JsonProperty(value="nls")
        private Object nls;
        @JsonProperty(value="uiConfig")
        private Object uiConfig;
        @JsonProperty(value="dataConfig")
        private List<Object> dataConfig;
        @JsonProperty(value="state")
        private State state;
        @JsonProperty(value="drilldownConfig")
        private Object drilldownConfig;
        @JsonProperty(value="parametersMap")
        private Object parametersMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder savedSearchId(String savedSearchId) {
            this.savedSearchId = savedSearchId;
            this.__explicitlySet__.add("savedSearchId");
            return this;
        }

        public Builder row(Integer row) {
            this.row = row;
            this.__explicitlySet__.add("row");
            return this;
        }

        public Builder column(Integer column) {
            this.column = column;
            this.__explicitlySet__.add("column");
            return this;
        }

        public Builder height(Integer height) {
            this.height = height;
            this.__explicitlySet__.add("height");
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            this.__explicitlySet__.add("width");
            return this;
        }

        public Builder nls(Object nls) {
            this.nls = nls;
            this.__explicitlySet__.add("nls");
            return this;
        }

        public Builder uiConfig(Object uiConfig) {
            this.uiConfig = uiConfig;
            this.__explicitlySet__.add("uiConfig");
            return this;
        }

        public Builder dataConfig(List<Object> dataConfig) {
            this.dataConfig = dataConfig;
            this.__explicitlySet__.add("dataConfig");
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder drilldownConfig(Object drilldownConfig) {
            this.drilldownConfig = drilldownConfig;
            this.__explicitlySet__.add("drilldownConfig");
            return this;
        }

        public Builder parametersMap(Object parametersMap) {
            this.parametersMap = parametersMap;
            this.__explicitlySet__.add("parametersMap");
            return this;
        }

        public ManagementDashboardTileDetails build() {
            ManagementDashboardTileDetails model = new ManagementDashboardTileDetails(this.displayName, this.savedSearchId, this.row, this.column, this.height, this.width, this.nls, this.uiConfig, this.dataConfig, this.state, this.drilldownConfig, this.parametersMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagementDashboardTileDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("savedSearchId")) {
                this.savedSearchId(model.getSavedSearchId());
            }
            if (model.wasPropertyExplicitlySet("row")) {
                this.row(model.getRow());
            }
            if (model.wasPropertyExplicitlySet("column")) {
                this.column(model.getColumn());
            }
            if (model.wasPropertyExplicitlySet("height")) {
                this.height(model.getHeight());
            }
            if (model.wasPropertyExplicitlySet("width")) {
                this.width(model.getWidth());
            }
            if (model.wasPropertyExplicitlySet("nls")) {
                this.nls(model.getNls());
            }
            if (model.wasPropertyExplicitlySet("uiConfig")) {
                this.uiConfig(model.getUiConfig());
            }
            if (model.wasPropertyExplicitlySet("dataConfig")) {
                this.dataConfig(model.getDataConfig());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("drilldownConfig")) {
                this.drilldownConfig(model.getDrilldownConfig());
            }
            if (model.wasPropertyExplicitlySet("parametersMap")) {
                this.parametersMap(model.getParametersMap());
            }
            return this;
        }
    }
}

