/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard;

import com.oracle.bmc.managementdashboard.DashxApis;
import com.oracle.bmc.managementdashboard.model.LifecycleStates;
import com.oracle.bmc.managementdashboard.requests.GetManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.responses.GetManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementSavedSearchResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DashxApisWaiters {
    private final ExecutorService executorService;
    private final DashxApis client;

    public DashxApisWaiters(ExecutorService executorService, DashxApis client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetManagementDashboardRequest, GetManagementDashboardResponse> forManagementDashboard(GetManagementDashboardRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagementDashboard(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagementDashboardRequest, GetManagementDashboardResponse> forManagementDashboard(GetManagementDashboardRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagementDashboard(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagementDashboardRequest, GetManagementDashboardResponse> forManagementDashboard(GetManagementDashboardRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagementDashboard(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagementDashboardRequest, GetManagementDashboardResponse> forManagementDashboard(BmcGenericWaiter waiter, GetManagementDashboardRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagementDashboardRequest, GetManagementDashboardResponse>(){

            @Override
            public GetManagementDashboardResponse apply(GetManagementDashboardRequest request) {
                return DashxApisWaiters.this.client.getManagementDashboard(request);
            }
        }, (Predicate)new Predicate<GetManagementDashboardResponse>(){

            @Override
            public boolean test(GetManagementDashboardResponse response) {
                return targetStatesSet.contains((Object)response.getManagementDashboard().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> forManagementSavedSearch(GetManagementSavedSearchRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagementSavedSearch(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> forManagementSavedSearch(GetManagementSavedSearchRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagementSavedSearch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> forManagementSavedSearch(GetManagementSavedSearchRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagementSavedSearch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> forManagementSavedSearch(BmcGenericWaiter waiter, GetManagementSavedSearchRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse>(){

            @Override
            public GetManagementSavedSearchResponse apply(GetManagementSavedSearchRequest request) {
                return DashxApisWaiters.this.client.getManagementSavedSearch(request);
            }
        }, (Predicate)new Predicate<GetManagementSavedSearchResponse>(){

            @Override
            public boolean test(GetManagementSavedSearchResponse response) {
                return targetStatesSet.contains((Object)response.getManagementSavedSearch().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

