/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.managementdashboard.DashxApis;
import com.oracle.bmc.managementdashboard.DashxApisAsyncClient;
import com.oracle.bmc.managementdashboard.DashxApisPaginators;
import com.oracle.bmc.managementdashboard.DashxApisWaiters;
import com.oracle.bmc.managementdashboard.model.ManagementDashboard;
import com.oracle.bmc.managementdashboard.model.ManagementDashboardCollection;
import com.oracle.bmc.managementdashboard.model.ManagementDashboardExportDetails;
import com.oracle.bmc.managementdashboard.model.ManagementSavedSearch;
import com.oracle.bmc.managementdashboard.model.ManagementSavedSearchCollection;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementDashboardsCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementSavedSearchesCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ExportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ImportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementDashboardsRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementSavedSearchesRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementDashboardsCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementSavedSearchesCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ExportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ImportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementDashboardsResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementSavedSearchesResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementSavedSearchResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashxApisClient
extends BaseSyncClient
implements DashxApis {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHXAPIS").serviceEndpointPrefix("").serviceEndpointTemplate("https://managementdashboard.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DashxApisAsyncClient.class);
    private final DashxApisWaiters waiters;
    private final DashxApisPaginators paginators;

    private DashxApisClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DashxApis-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DashxApisWaiters(executorService, this);
        this.paginators = new DashxApisPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeManagementDashboardsCompartmentResponse changeManagementDashboardsCompartment(ChangeManagementDashboardsCompartmentRequest request) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagementDashboardsCompartmentDetails(), "changeManagementDashboardsCompartmentDetails is required");
        return (ChangeManagementDashboardsCompartmentResponse)this.clientCall(request, ChangeManagementDashboardsCompartmentResponse::builder).logger(LOG, "changeManagementDashboardsCompartment").serviceDetails("DashxApis", "ChangeManagementDashboardsCompartment", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/ChangeManagementDashboardsCompartment").method(Method.POST).requestBuilder(ChangeManagementDashboardsCompartmentRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, ChangeManagementDashboardsCompartmentResponse.Builder::managementDashboard).handleResponseHeaderString("etag", ChangeManagementDashboardsCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeManagementDashboardsCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeManagementDashboardsCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeManagementSavedSearchesCompartmentResponse changeManagementSavedSearchesCompartment(ChangeManagementSavedSearchesCompartmentRequest request) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagementSavedSearchesCompartmentDetails(), "changeManagementSavedSearchesCompartmentDetails is required");
        return (ChangeManagementSavedSearchesCompartmentResponse)this.clientCall(request, ChangeManagementSavedSearchesCompartmentResponse::builder).logger(LOG, "changeManagementSavedSearchesCompartment").serviceDetails("DashxApis", "ChangeManagementSavedSearchesCompartment", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/ChangeManagementSavedSearchesCompartment").method(Method.POST).requestBuilder(ChangeManagementSavedSearchesCompartmentRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, ChangeManagementSavedSearchesCompartmentResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", ChangeManagementSavedSearchesCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeManagementSavedSearchesCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeManagementSavedSearchesCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateManagementDashboardResponse createManagementDashboard(CreateManagementDashboardRequest request) {
        Objects.requireNonNull(request.getCreateManagementDashboardDetails(), "createManagementDashboardDetails is required");
        return (CreateManagementDashboardResponse)this.clientCall(request, CreateManagementDashboardResponse::builder).logger(LOG, "createManagementDashboard").serviceDetails("DashxApis", "CreateManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/CreateManagementDashboard").method(Method.POST).requestBuilder(CreateManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, CreateManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", CreateManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateManagementDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateManagementSavedSearchResponse createManagementSavedSearch(CreateManagementSavedSearchRequest request) {
        Objects.requireNonNull(request.getCreateManagementSavedSearchDetails(), "createManagementSavedSearchDetails is required");
        return (CreateManagementSavedSearchResponse)this.clientCall(request, CreateManagementSavedSearchResponse::builder).logger(LOG, "createManagementSavedSearch").serviceDetails("DashxApis", "CreateManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/CreateManagementSavedSearch").method(Method.POST).requestBuilder(CreateManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, CreateManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", CreateManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateManagementSavedSearchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteManagementDashboardResponse deleteManagementDashboard(DeleteManagementDashboardRequest request) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        return (DeleteManagementDashboardResponse)this.clientCall(request, DeleteManagementDashboardResponse::builder).logger(LOG, "deleteManagementDashboard").serviceDetails("DashxApis", "DeleteManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/DeleteManagementDashboard").method(Method.DELETE).requestBuilder(DeleteManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteManagementDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteManagementSavedSearchResponse deleteManagementSavedSearch(DeleteManagementSavedSearchRequest request) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        return (DeleteManagementSavedSearchResponse)this.clientCall(request, DeleteManagementSavedSearchResponse::builder).logger(LOG, "deleteManagementSavedSearch").serviceDetails("DashxApis", "DeleteManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/DeleteManagementSavedSearch").method(Method.DELETE).requestBuilder(DeleteManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteManagementSavedSearchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportDashboardResponse exportDashboard(ExportDashboardRequest request) {
        Validate.notBlank((String)request.getExportDashboardId(), (String)"exportDashboardId must not be blank", (Object[])new Object[0]);
        return (ExportDashboardResponse)this.clientCall(request, ExportDashboardResponse::builder).logger(LOG, "exportDashboard").serviceDetails("DashxApis", "ExportDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboardImportDetails/ExportDashboard").method(Method.GET).requestBuilder(ExportDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam("actions").appendPathParam("exportDashboard").appendPathParam(request.getExportDashboardId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboardExportDetails.class, ExportDashboardResponse.Builder::managementDashboardExportDetails).handleResponseHeaderString("opc-work-request-id", ExportDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExportDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagementDashboardResponse getManagementDashboard(GetManagementDashboardRequest request) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        return (GetManagementDashboardResponse)this.clientCall(request, GetManagementDashboardResponse::builder).logger(LOG, "getManagementDashboard").serviceDetails("DashxApis", "GetManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/GetManagementDashboard").method(Method.GET).requestBuilder(GetManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboard.class, GetManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", GetManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", GetManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetManagementDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagementSavedSearchResponse getManagementSavedSearch(GetManagementSavedSearchRequest request) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        return (GetManagementSavedSearchResponse)this.clientCall(request, GetManagementSavedSearchResponse::builder).logger(LOG, "getManagementSavedSearch").serviceDetails("DashxApis", "GetManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/GetManagementSavedSearch").method(Method.GET).requestBuilder(GetManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementSavedSearch.class, GetManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", GetManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", GetManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetManagementSavedSearchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportDashboardResponse importDashboard(ImportDashboardRequest request) {
        Objects.requireNonNull(request.getManagementDashboardImportDetails(), "managementDashboardImportDetails is required");
        return (ImportDashboardResponse)this.clientCall(request, ImportDashboardResponse::builder).logger(LOG, "importDashboard").serviceDetails("DashxApis", "ImportDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboardImportDetails/ImportDashboard").method(Method.POST).requestBuilder(ImportDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam("actions").appendPathParam("importDashboard").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ImportDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListManagementDashboardsResponse listManagementDashboards(ListManagementDashboardsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagementDashboardsResponse)this.clientCall(request, ListManagementDashboardsResponse::builder).logger(LOG, "listManagementDashboards").serviceDetails("DashxApis", "ListManagementDashboards", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/ListManagementDashboards").method(Method.GET).requestBuilder(ListManagementDashboardsRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboardCollection.class, ListManagementDashboardsResponse.Builder::managementDashboardCollection).handleResponseHeaderString("opc-request-id", ListManagementDashboardsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagementDashboardsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagementSavedSearchesResponse listManagementSavedSearches(ListManagementSavedSearchesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagementSavedSearchesResponse)this.clientCall(request, ListManagementSavedSearchesResponse::builder).logger(LOG, "listManagementSavedSearches").serviceDetails("DashxApis", "ListManagementSavedSearches", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/ListManagementSavedSearches").method(Method.GET).requestBuilder(ListManagementSavedSearchesRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementSavedSearchCollection.class, ListManagementSavedSearchesResponse.Builder::managementSavedSearchCollection).handleResponseHeaderString("opc-request-id", ListManagementSavedSearchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagementSavedSearchesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateManagementDashboardResponse updateManagementDashboard(UpdateManagementDashboardRequest request) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagementDashboardDetails(), "updateManagementDashboardDetails is required");
        return (UpdateManagementDashboardResponse)this.clientCall(request, UpdateManagementDashboardResponse::builder).logger(LOG, "updateManagementDashboard").serviceDetails("DashxApis", "UpdateManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/UpdateManagementDashboard").method(Method.PUT).requestBuilder(UpdateManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, UpdateManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", UpdateManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateManagementDashboardResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateManagementSavedSearchResponse updateManagementSavedSearch(UpdateManagementSavedSearchRequest request) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagementSavedSearchDetails(), "updateManagementSavedSearchDetails is required");
        return (UpdateManagementSavedSearchResponse)this.clientCall(request, UpdateManagementSavedSearchResponse::builder).logger(LOG, "updateManagementSavedSearch").serviceDetails("DashxApis", "UpdateManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/UpdateManagementSavedSearch").method(Method.PUT).requestBuilder(UpdateManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, UpdateManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", UpdateManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateManagementSavedSearchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DashxApisWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DashxApisPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DashxApisClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DashxApisClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DashxApisClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashxApisClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashxApisClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DashxApisClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DashxApisClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

