/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.logging.model.UpdateLogGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateLogGroupRequest
extends BmcRequest<UpdateLogGroupDetails> {
    private String logGroupId;
    private UpdateLogGroupDetails updateLogGroupDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public UpdateLogGroupDetails getUpdateLogGroupDetails() {
        return this.updateLogGroupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateLogGroupDetails getBody$() {
        return this.updateLogGroupDetails;
    }

    public Builder toBuilder() {
        return new Builder().logGroupId(this.logGroupId).updateLogGroupDetails(this.updateLogGroupDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",updateLogGroupDetails=").append(String.valueOf((Object)this.updateLogGroupDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateLogGroupRequest)) {
            return false;
        }
        UpdateLogGroupRequest other = (UpdateLogGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals((Object)this.updateLogGroupDetails, (Object)other.updateLogGroupDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.updateLogGroupDetails == null ? 43 : this.updateLogGroupDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateLogGroupRequest, UpdateLogGroupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logGroupId = null;
        private UpdateLogGroupDetails updateLogGroupDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder updateLogGroupDetails(UpdateLogGroupDetails updateLogGroupDetails) {
            this.updateLogGroupDetails = updateLogGroupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateLogGroupRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.updateLogGroupDetails(o.getUpdateLogGroupDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateLogGroupRequest build() {
            UpdateLogGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateLogGroupDetails body) {
            this.updateLogGroupDetails(body);
            return this;
        }

        public UpdateLogGroupRequest buildWithoutInvocationCallback() {
            UpdateLogGroupRequest request = new UpdateLogGroupRequest();
            request.logGroupId = this.logGroupId;
            request.updateLogGroupDetails = this.updateLogGroupDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

