/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetUnifiedAgentConfigurationRequest
extends BmcRequest<Void> {
    private String unifiedAgentConfigurationId;
    private String opcRequestId;

    public String getUnifiedAgentConfigurationId() {
        return this.unifiedAgentConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().unifiedAgentConfigurationId(this.unifiedAgentConfigurationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",unifiedAgentConfigurationId=").append(String.valueOf(this.unifiedAgentConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUnifiedAgentConfigurationRequest)) {
            return false;
        }
        GetUnifiedAgentConfigurationRequest other = (GetUnifiedAgentConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.unifiedAgentConfigurationId, other.unifiedAgentConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.unifiedAgentConfigurationId == null ? 43 : this.unifiedAgentConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUnifiedAgentConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String unifiedAgentConfigurationId = null;
        private String opcRequestId = null;

        public Builder unifiedAgentConfigurationId(String unifiedAgentConfigurationId) {
            this.unifiedAgentConfigurationId = unifiedAgentConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUnifiedAgentConfigurationRequest o) {
            this.unifiedAgentConfigurationId(o.getUnifiedAgentConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUnifiedAgentConfigurationRequest build() {
            GetUnifiedAgentConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetUnifiedAgentConfigurationRequest buildWithoutInvocationCallback() {
            GetUnifiedAgentConfigurationRequest request = new GetUnifiedAgentConfigurationRequest();
            request.unifiedAgentConfigurationId = this.unifiedAgentConfigurationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

