/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentSyslogParser
extends UnifiedAgentParser {
    @JsonProperty(value="timeFormat")
    private final String timeFormat;
    @JsonProperty(value="rfc5424TimeFormat")
    private final String rfc5424TimeFormat;
    @JsonProperty(value="messageFormat")
    private final MessageFormat messageFormat;
    @JsonProperty(value="isWithPriority")
    private final Boolean isWithPriority;
    @JsonProperty(value="isSupportColonlessIdent")
    private final Boolean isSupportColonlessIdent;
    @JsonProperty(value="syslogParserType")
    private final SyslogParserType syslogParserType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentSyslogParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds, String timeFormat, String rfc5424TimeFormat, MessageFormat messageFormat, Boolean isWithPriority, Boolean isSupportColonlessIdent, SyslogParserType syslogParserType) {
        super(fieldTimeKey, types, nullValuePattern, isNullEmptyString, isEstimateCurrentEvent, isKeepTimeKey, timeoutInMilliseconds);
        this.timeFormat = timeFormat;
        this.rfc5424TimeFormat = rfc5424TimeFormat;
        this.messageFormat = messageFormat;
        this.isWithPriority = isWithPriority;
        this.isSupportColonlessIdent = isSupportColonlessIdent;
        this.syslogParserType = syslogParserType;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getRfc5424TimeFormat() {
        return this.rfc5424TimeFormat;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public Boolean getIsWithPriority() {
        return this.isWithPriority;
    }

    public Boolean getIsSupportColonlessIdent() {
        return this.isSupportColonlessIdent;
    }

    public SyslogParserType getSyslogParserType() {
        return this.syslogParserType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentSyslogParser(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", timeFormat=").append(String.valueOf(this.timeFormat));
        sb.append(", rfc5424TimeFormat=").append(String.valueOf(this.rfc5424TimeFormat));
        sb.append(", messageFormat=").append(String.valueOf((Object)this.messageFormat));
        sb.append(", isWithPriority=").append(String.valueOf(this.isWithPriority));
        sb.append(", isSupportColonlessIdent=").append(String.valueOf(this.isSupportColonlessIdent));
        sb.append(", syslogParserType=").append(String.valueOf((Object)this.syslogParserType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentSyslogParser)) {
            return false;
        }
        UnifiedAgentSyslogParser other = (UnifiedAgentSyslogParser)((Object)o);
        return Objects.equals(this.timeFormat, other.timeFormat) && Objects.equals(this.rfc5424TimeFormat, other.rfc5424TimeFormat) && Objects.equals((Object)this.messageFormat, (Object)other.messageFormat) && Objects.equals(this.isWithPriority, other.isWithPriority) && Objects.equals(this.isSupportColonlessIdent, other.isSupportColonlessIdent) && Objects.equals((Object)this.syslogParserType, (Object)other.syslogParserType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.timeFormat == null ? 43 : this.timeFormat.hashCode());
        result = result * 59 + (this.rfc5424TimeFormat == null ? 43 : this.rfc5424TimeFormat.hashCode());
        result = result * 59 + (this.messageFormat == null ? 43 : this.messageFormat.hashCode());
        result = result * 59 + (this.isWithPriority == null ? 43 : this.isWithPriority.hashCode());
        result = result * 59 + (this.isSupportColonlessIdent == null ? 43 : this.isSupportColonlessIdent.hashCode());
        result = result * 59 + (this.syslogParserType == null ? 43 : this.syslogParserType.hashCode());
        return result;
    }

    public static enum SyslogParserType implements BmcEnum
    {
        String("STRING"),
        Regexp("REGEXP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SyslogParserType> map;

        private SyslogParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SyslogParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SyslogParserType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SyslogParserType.class);
            map = new HashMap<String, SyslogParserType>();
            for (SyslogParserType v : SyslogParserType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MessageFormat implements BmcEnum
    {
        Rfc3164("RFC3164"),
        Rfc5424("RFC5424"),
        Auto("AUTO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageFormat> map;

        private MessageFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageFormat.class);
            map = new HashMap<String, MessageFormat>();
            for (MessageFormat v : MessageFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldTimeKey")
        private String fieldTimeKey;
        @JsonProperty(value="types")
        private Map<String, String> types;
        @JsonProperty(value="nullValuePattern")
        private String nullValuePattern;
        @JsonProperty(value="isNullEmptyString")
        private Boolean isNullEmptyString;
        @JsonProperty(value="isEstimateCurrentEvent")
        private Boolean isEstimateCurrentEvent;
        @JsonProperty(value="isKeepTimeKey")
        private Boolean isKeepTimeKey;
        @JsonProperty(value="timeoutInMilliseconds")
        private Integer timeoutInMilliseconds;
        @JsonProperty(value="timeFormat")
        private String timeFormat;
        @JsonProperty(value="rfc5424TimeFormat")
        private String rfc5424TimeFormat;
        @JsonProperty(value="messageFormat")
        private MessageFormat messageFormat;
        @JsonProperty(value="isWithPriority")
        private Boolean isWithPriority;
        @JsonProperty(value="isSupportColonlessIdent")
        private Boolean isSupportColonlessIdent;
        @JsonProperty(value="syslogParserType")
        private SyslogParserType syslogParserType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldTimeKey(String fieldTimeKey) {
            this.fieldTimeKey = fieldTimeKey;
            this.__explicitlySet__.add("fieldTimeKey");
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder nullValuePattern(String nullValuePattern) {
            this.nullValuePattern = nullValuePattern;
            this.__explicitlySet__.add("nullValuePattern");
            return this;
        }

        public Builder isNullEmptyString(Boolean isNullEmptyString) {
            this.isNullEmptyString = isNullEmptyString;
            this.__explicitlySet__.add("isNullEmptyString");
            return this;
        }

        public Builder isEstimateCurrentEvent(Boolean isEstimateCurrentEvent) {
            this.isEstimateCurrentEvent = isEstimateCurrentEvent;
            this.__explicitlySet__.add("isEstimateCurrentEvent");
            return this;
        }

        public Builder isKeepTimeKey(Boolean isKeepTimeKey) {
            this.isKeepTimeKey = isKeepTimeKey;
            this.__explicitlySet__.add("isKeepTimeKey");
            return this;
        }

        public Builder timeoutInMilliseconds(Integer timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.__explicitlySet__.add("timeoutInMilliseconds");
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            this.__explicitlySet__.add("timeFormat");
            return this;
        }

        public Builder rfc5424TimeFormat(String rfc5424TimeFormat) {
            this.rfc5424TimeFormat = rfc5424TimeFormat;
            this.__explicitlySet__.add("rfc5424TimeFormat");
            return this;
        }

        public Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat = messageFormat;
            this.__explicitlySet__.add("messageFormat");
            return this;
        }

        public Builder isWithPriority(Boolean isWithPriority) {
            this.isWithPriority = isWithPriority;
            this.__explicitlySet__.add("isWithPriority");
            return this;
        }

        public Builder isSupportColonlessIdent(Boolean isSupportColonlessIdent) {
            this.isSupportColonlessIdent = isSupportColonlessIdent;
            this.__explicitlySet__.add("isSupportColonlessIdent");
            return this;
        }

        public Builder syslogParserType(SyslogParserType syslogParserType) {
            this.syslogParserType = syslogParserType;
            this.__explicitlySet__.add("syslogParserType");
            return this;
        }

        public UnifiedAgentSyslogParser build() {
            UnifiedAgentSyslogParser model = new UnifiedAgentSyslogParser(this.fieldTimeKey, this.types, this.nullValuePattern, this.isNullEmptyString, this.isEstimateCurrentEvent, this.isKeepTimeKey, this.timeoutInMilliseconds, this.timeFormat, this.rfc5424TimeFormat, this.messageFormat, this.isWithPriority, this.isSupportColonlessIdent, this.syslogParserType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentSyslogParser model) {
            if (model.wasPropertyExplicitlySet("fieldTimeKey")) {
                this.fieldTimeKey(model.getFieldTimeKey());
            }
            if (model.wasPropertyExplicitlySet("types")) {
                this.types(model.getTypes());
            }
            if (model.wasPropertyExplicitlySet("nullValuePattern")) {
                this.nullValuePattern(model.getNullValuePattern());
            }
            if (model.wasPropertyExplicitlySet("isNullEmptyString")) {
                this.isNullEmptyString(model.getIsNullEmptyString());
            }
            if (model.wasPropertyExplicitlySet("isEstimateCurrentEvent")) {
                this.isEstimateCurrentEvent(model.getIsEstimateCurrentEvent());
            }
            if (model.wasPropertyExplicitlySet("isKeepTimeKey")) {
                this.isKeepTimeKey(model.getIsKeepTimeKey());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMilliseconds")) {
                this.timeoutInMilliseconds(model.getTimeoutInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("timeFormat")) {
                this.timeFormat(model.getTimeFormat());
            }
            if (model.wasPropertyExplicitlySet("rfc5424TimeFormat")) {
                this.rfc5424TimeFormat(model.getRfc5424TimeFormat());
            }
            if (model.wasPropertyExplicitlySet("messageFormat")) {
                this.messageFormat(model.getMessageFormat());
            }
            if (model.wasPropertyExplicitlySet("isWithPriority")) {
                this.isWithPriority(model.getIsWithPriority());
            }
            if (model.wasPropertyExplicitlySet("isSupportColonlessIdent")) {
                this.isSupportColonlessIdent(model.getIsSupportColonlessIdent());
            }
            if (model.wasPropertyExplicitlySet("syslogParserType")) {
                this.syslogParserType(model.getSyslogParserType());
            }
            return this;
        }
    }
}

