/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.oracle.bmc.logging.LoggingManagement;
import com.oracle.bmc.logging.model.LogGroupLifecycleState;
import com.oracle.bmc.logging.model.LogLifecycleState;
import com.oracle.bmc.logging.model.LogSavedSearchLifecycleState;
import com.oracle.bmc.logging.requests.GetLogGroupRequest;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.requests.GetLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.GetUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.GetWorkRequestRequest;
import com.oracle.bmc.logging.responses.GetLogGroupResponse;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.logging.responses.GetLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.GetUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class LoggingManagementWaiters {
    private final ExecutorService executorService;
    private final LoggingManagement client;

    public LoggingManagementWaiters(ExecutorService executorService, LoggingManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetLogRequest, GetLogResponse> forLog(GetLogRequest request, LogLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLog(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogRequest, GetLogResponse> forLog(GetLogRequest request, LogLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogRequest, GetLogResponse> forLog(GetLogRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LogLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogRequest, GetLogResponse> forLog(BmcGenericWaiter waiter, GetLogRequest request, LogLifecycleState ... targetStates) {
        final HashSet<LogLifecycleState> targetStatesSet = new HashSet<LogLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLogRequest, GetLogResponse>(){

            @Override
            public GetLogResponse apply(GetLogRequest request) {
                return LoggingManagementWaiters.this.client.getLog(request);
            }
        }, (Predicate)new Predicate<GetLogResponse>(){

            @Override
            public boolean test(GetLogResponse response) {
                return targetStatesSet.contains((Object)response.getLog().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetLogGroupRequest, GetLogGroupResponse> forLogGroup(GetLogGroupRequest request, LogGroupLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogGroupRequest, GetLogGroupResponse> forLogGroup(GetLogGroupRequest request, LogGroupLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLogGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogGroupRequest, GetLogGroupResponse> forLogGroup(GetLogGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LogGroupLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogGroupRequest, GetLogGroupResponse> forLogGroup(BmcGenericWaiter waiter, GetLogGroupRequest request, LogGroupLifecycleState ... targetStates) {
        final HashSet<LogGroupLifecycleState> targetStatesSet = new HashSet<LogGroupLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLogGroupRequest, GetLogGroupResponse>(){

            @Override
            public GetLogGroupResponse apply(GetLogGroupRequest request) {
                return LoggingManagementWaiters.this.client.getLogGroup(request);
            }
        }, (Predicate)new Predicate<GetLogGroupResponse>(){

            @Override
            public boolean test(GetLogGroupResponse response) {
                return targetStatesSet.contains((Object)response.getLogGroup().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetLogSavedSearchRequest, GetLogSavedSearchResponse> forLogSavedSearch(GetLogSavedSearchRequest request, LogSavedSearchLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogSavedSearch(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogSavedSearchRequest, GetLogSavedSearchResponse> forLogSavedSearch(GetLogSavedSearchRequest request, LogSavedSearchLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLogSavedSearch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogSavedSearchRequest, GetLogSavedSearchResponse> forLogSavedSearch(GetLogSavedSearchRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LogSavedSearchLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogSavedSearch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogSavedSearchRequest, GetLogSavedSearchResponse> forLogSavedSearch(BmcGenericWaiter waiter, GetLogSavedSearchRequest request, LogSavedSearchLifecycleState ... targetStates) {
        final HashSet<LogSavedSearchLifecycleState> targetStatesSet = new HashSet<LogSavedSearchLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLogSavedSearchRequest, GetLogSavedSearchResponse>(){

            @Override
            public GetLogSavedSearchResponse apply(GetLogSavedSearchRequest request) {
                return LoggingManagementWaiters.this.client.getLogSavedSearch(request);
            }
        }, (Predicate)new Predicate<GetLogSavedSearchResponse>(){

            @Override
            public boolean test(GetLogSavedSearchResponse response) {
                return targetStatesSet.contains((Object)response.getLogSavedSearch().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> forUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request, LogLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUnifiedAgentConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> forUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request, LogLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUnifiedAgentConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> forUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LogLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUnifiedAgentConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> forUnifiedAgentConfiguration(BmcGenericWaiter waiter, GetUnifiedAgentConfigurationRequest request, LogLifecycleState ... targetStates) {
        final HashSet<LogLifecycleState> targetStatesSet = new HashSet<LogLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse>(){

            @Override
            public GetUnifiedAgentConfigurationResponse apply(GetUnifiedAgentConfigurationRequest request) {
                return LoggingManagementWaiters.this.client.getUnifiedAgentConfiguration(request);
            }
        }, (Predicate)new Predicate<GetUnifiedAgentConfigurationResponse>(){

            @Override
            public boolean test(GetUnifiedAgentConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getUnifiedAgentConfiguration().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return LoggingManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

