/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.oracle.bmc.logging.LoggingManagement;
import com.oracle.bmc.logging.model.LogGroupSummary;
import com.oracle.bmc.logging.model.LogIncludedSearchSummary;
import com.oracle.bmc.logging.model.LogSavedSearchSummary;
import com.oracle.bmc.logging.model.LogSummary;
import com.oracle.bmc.logging.model.UnifiedAgentConfigurationSummary;
import com.oracle.bmc.logging.model.WorkRequestError;
import com.oracle.bmc.logging.model.WorkRequestLog;
import com.oracle.bmc.logging.model.WorkRequestSummary;
import com.oracle.bmc.logging.requests.ListLogGroupsRequest;
import com.oracle.bmc.logging.requests.ListLogIncludedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogSavedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogsRequest;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestsRequest;
import com.oracle.bmc.logging.responses.ListLogGroupsResponse;
import com.oracle.bmc.logging.responses.ListLogIncludedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogSavedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogsResponse;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LoggingManagementPaginators {
    private final LoggingManagement client;

    public LoggingManagementPaginators(LoggingManagement client) {
        this.client = client;
    }

    public Iterable<ListLogGroupsResponse> listLogGroupsResponseIterator(final ListLogGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLogGroupsRequest.Builder>(){

            @Override
            public ListLogGroupsRequest.Builder get() {
                return ListLogGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogGroupsResponse, String>(){

            @Override
            public String apply(ListLogGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogGroupsRequest.Builder>, ListLogGroupsRequest>(){

            @Override
            public ListLogGroupsRequest apply(RequestBuilderAndToken<ListLogGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogGroupsRequest, ListLogGroupsResponse>(){

            @Override
            public ListLogGroupsResponse apply(ListLogGroupsRequest request) {
                return LoggingManagementPaginators.this.client.listLogGroups(request);
            }
        });
    }

    public Iterable<LogGroupSummary> listLogGroupsRecordIterator(final ListLogGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLogGroupsRequest.Builder>(){

            @Override
            public ListLogGroupsRequest.Builder get() {
                return ListLogGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogGroupsResponse, String>(){

            @Override
            public String apply(ListLogGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogGroupsRequest.Builder>, ListLogGroupsRequest>(){

            @Override
            public ListLogGroupsRequest apply(RequestBuilderAndToken<ListLogGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogGroupsRequest, ListLogGroupsResponse>(){

            @Override
            public ListLogGroupsResponse apply(ListLogGroupsRequest request) {
                return LoggingManagementPaginators.this.client.listLogGroups(request);
            }
        }, (Function)new Function<ListLogGroupsResponse, List<LogGroupSummary>>(){

            @Override
            public List<LogGroupSummary> apply(ListLogGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListLogIncludedSearchesResponse> listLogIncludedSearchesResponseIterator(final ListLogIncludedSearchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLogIncludedSearchesRequest.Builder>(){

            @Override
            public ListLogIncludedSearchesRequest.Builder get() {
                return ListLogIncludedSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogIncludedSearchesResponse, String>(){

            @Override
            public String apply(ListLogIncludedSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogIncludedSearchesRequest.Builder>, ListLogIncludedSearchesRequest>(){

            @Override
            public ListLogIncludedSearchesRequest apply(RequestBuilderAndToken<ListLogIncludedSearchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogIncludedSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogIncludedSearchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogIncludedSearchesRequest, ListLogIncludedSearchesResponse>(){

            @Override
            public ListLogIncludedSearchesResponse apply(ListLogIncludedSearchesRequest request) {
                return LoggingManagementPaginators.this.client.listLogIncludedSearches(request);
            }
        });
    }

    public Iterable<LogIncludedSearchSummary> listLogIncludedSearchesRecordIterator(final ListLogIncludedSearchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLogIncludedSearchesRequest.Builder>(){

            @Override
            public ListLogIncludedSearchesRequest.Builder get() {
                return ListLogIncludedSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogIncludedSearchesResponse, String>(){

            @Override
            public String apply(ListLogIncludedSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogIncludedSearchesRequest.Builder>, ListLogIncludedSearchesRequest>(){

            @Override
            public ListLogIncludedSearchesRequest apply(RequestBuilderAndToken<ListLogIncludedSearchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogIncludedSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogIncludedSearchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogIncludedSearchesRequest, ListLogIncludedSearchesResponse>(){

            @Override
            public ListLogIncludedSearchesResponse apply(ListLogIncludedSearchesRequest request) {
                return LoggingManagementPaginators.this.client.listLogIncludedSearches(request);
            }
        }, (Function)new Function<ListLogIncludedSearchesResponse, List<LogIncludedSearchSummary>>(){

            @Override
            public List<LogIncludedSearchSummary> apply(ListLogIncludedSearchesResponse response) {
                return response.getLogIncludedSearchSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListLogSavedSearchesResponse> listLogSavedSearchesResponseIterator(final ListLogSavedSearchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLogSavedSearchesRequest.Builder>(){

            @Override
            public ListLogSavedSearchesRequest.Builder get() {
                return ListLogSavedSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogSavedSearchesResponse, String>(){

            @Override
            public String apply(ListLogSavedSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogSavedSearchesRequest.Builder>, ListLogSavedSearchesRequest>(){

            @Override
            public ListLogSavedSearchesRequest apply(RequestBuilderAndToken<ListLogSavedSearchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogSavedSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogSavedSearchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse>(){

            @Override
            public ListLogSavedSearchesResponse apply(ListLogSavedSearchesRequest request) {
                return LoggingManagementPaginators.this.client.listLogSavedSearches(request);
            }
        });
    }

    public Iterable<LogSavedSearchSummary> listLogSavedSearchesRecordIterator(final ListLogSavedSearchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLogSavedSearchesRequest.Builder>(){

            @Override
            public ListLogSavedSearchesRequest.Builder get() {
                return ListLogSavedSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogSavedSearchesResponse, String>(){

            @Override
            public String apply(ListLogSavedSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogSavedSearchesRequest.Builder>, ListLogSavedSearchesRequest>(){

            @Override
            public ListLogSavedSearchesRequest apply(RequestBuilderAndToken<ListLogSavedSearchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogSavedSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogSavedSearchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse>(){

            @Override
            public ListLogSavedSearchesResponse apply(ListLogSavedSearchesRequest request) {
                return LoggingManagementPaginators.this.client.listLogSavedSearches(request);
            }
        }, (Function)new Function<ListLogSavedSearchesResponse, List<LogSavedSearchSummary>>(){

            @Override
            public List<LogSavedSearchSummary> apply(ListLogSavedSearchesResponse response) {
                return response.getLogSavedSearchSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListLogsResponse> listLogsResponseIterator(final ListLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLogsRequest.Builder>(){

            @Override
            public ListLogsRequest.Builder get() {
                return ListLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogsResponse, String>(){

            @Override
            public String apply(ListLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogsRequest.Builder>, ListLogsRequest>(){

            @Override
            public ListLogsRequest apply(RequestBuilderAndToken<ListLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogsRequest, ListLogsResponse>(){

            @Override
            public ListLogsResponse apply(ListLogsRequest request) {
                return LoggingManagementPaginators.this.client.listLogs(request);
            }
        });
    }

    public Iterable<LogSummary> listLogsRecordIterator(final ListLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLogsRequest.Builder>(){

            @Override
            public ListLogsRequest.Builder get() {
                return ListLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLogsResponse, String>(){

            @Override
            public String apply(ListLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLogsRequest.Builder>, ListLogsRequest>(){

            @Override
            public ListLogsRequest apply(RequestBuilderAndToken<ListLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLogsRequest, ListLogsResponse>(){

            @Override
            public ListLogsResponse apply(ListLogsRequest request) {
                return LoggingManagementPaginators.this.client.listLogs(request);
            }
        }, (Function)new Function<ListLogsResponse, List<LogSummary>>(){

            @Override
            public List<LogSummary> apply(ListLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListUnifiedAgentConfigurationsResponse> listUnifiedAgentConfigurationsResponseIterator(final ListUnifiedAgentConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUnifiedAgentConfigurationsRequest.Builder>(){

            @Override
            public ListUnifiedAgentConfigurationsRequest.Builder get() {
                return ListUnifiedAgentConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUnifiedAgentConfigurationsResponse, String>(){

            @Override
            public String apply(ListUnifiedAgentConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUnifiedAgentConfigurationsRequest.Builder>, ListUnifiedAgentConfigurationsRequest>(){

            @Override
            public ListUnifiedAgentConfigurationsRequest apply(RequestBuilderAndToken<ListUnifiedAgentConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUnifiedAgentConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUnifiedAgentConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse>(){

            @Override
            public ListUnifiedAgentConfigurationsResponse apply(ListUnifiedAgentConfigurationsRequest request) {
                return LoggingManagementPaginators.this.client.listUnifiedAgentConfigurations(request);
            }
        });
    }

    public Iterable<UnifiedAgentConfigurationSummary> listUnifiedAgentConfigurationsRecordIterator(final ListUnifiedAgentConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUnifiedAgentConfigurationsRequest.Builder>(){

            @Override
            public ListUnifiedAgentConfigurationsRequest.Builder get() {
                return ListUnifiedAgentConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUnifiedAgentConfigurationsResponse, String>(){

            @Override
            public String apply(ListUnifiedAgentConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUnifiedAgentConfigurationsRequest.Builder>, ListUnifiedAgentConfigurationsRequest>(){

            @Override
            public ListUnifiedAgentConfigurationsRequest apply(RequestBuilderAndToken<ListUnifiedAgentConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUnifiedAgentConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUnifiedAgentConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse>(){

            @Override
            public ListUnifiedAgentConfigurationsResponse apply(ListUnifiedAgentConfigurationsRequest request) {
                return LoggingManagementPaginators.this.client.listUnifiedAgentConfigurations(request);
            }
        }, (Function)new Function<ListUnifiedAgentConfigurationsResponse, List<UnifiedAgentConfigurationSummary>>(){

            @Override
            public List<UnifiedAgentConfigurationSummary> apply(ListUnifiedAgentConfigurationsResponse response) {
                return response.getUnifiedAgentConfigurationCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            @Override
            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoggingManagementPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

