/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.EventTypeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveSourceEventTypesRequest
extends BmcRequest<EventTypeDetails> {
    private String namespaceName;
    private String sourceName;
    private EventTypeDetails removeEventTypeDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public EventTypeDetails getRemoveEventTypeDetails() {
        return this.removeEventTypeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EventTypeDetails getBody$() {
        return this.removeEventTypeDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).sourceName(this.sourceName).removeEventTypeDetails(this.removeEventTypeDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",sourceName=").append(String.valueOf(this.sourceName));
        sb.append(",removeEventTypeDetails=").append(String.valueOf((Object)this.removeEventTypeDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveSourceEventTypesRequest)) {
            return false;
        }
        RemoveSourceEventTypesRequest other = (RemoveSourceEventTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals((Object)this.removeEventTypeDetails, (Object)other.removeEventTypeDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.removeEventTypeDetails == null ? 43 : this.removeEventTypeDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveSourceEventTypesRequest, EventTypeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String sourceName = null;
        private EventTypeDetails removeEventTypeDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder removeEventTypeDetails(EventTypeDetails removeEventTypeDetails) {
            this.removeEventTypeDetails = removeEventTypeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveSourceEventTypesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.sourceName(o.getSourceName());
            this.removeEventTypeDetails(o.getRemoveEventTypeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveSourceEventTypesRequest build() {
            RemoveSourceEventTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EventTypeDetails body) {
            this.removeEventTypeDetails(body);
            return this;
        }

        public RemoveSourceEventTypesRequest buildWithoutInvocationCallback() {
            RemoveSourceEventTypesRequest request = new RemoveSourceEventTypesRequest();
            request.namespaceName = this.namespaceName;
            request.sourceName = this.sourceName;
            request.removeEventTypeDetails = this.removeEventTypeDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

