/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.StorageOperationType;
import com.oracle.bmc.loganalytics.model.WorkRequestStatus;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListStorageWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String namespaceName;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private StorageOperationType operationType;
    private WorkRequestStatus status;
    private Date timeStarted;
    private Date timeFinished;
    private String policyName;
    private String policyId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public StorageOperationType getOperationType() {
        return this.operationType;
    }

    public WorkRequestStatus getStatus() {
        return this.status;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).namespaceName(this.namespaceName).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).operationType(this.operationType).status(this.status).timeStarted(this.timeStarted).timeFinished(this.timeFinished).policyName(this.policyName).policyId(this.policyId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(",timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(",policyName=").append(String.valueOf(this.policyName));
        sb.append(",policyId=").append(String.valueOf(this.policyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListStorageWorkRequestsRequest)) {
            return false;
        }
        ListStorageWorkRequestsRequest other = (ListStorageWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.policyName, other.policyName) && Objects.equals(this.policyId, other.policyId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.policyName == null ? 43 : this.policyName.hashCode());
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListStorageWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String namespaceName = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private StorageOperationType operationType = null;
        private WorkRequestStatus status = null;
        private Date timeStarted = null;
        private Date timeFinished = null;
        private String policyName = null;
        private String policyId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder operationType(StorageOperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder status(WorkRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListStorageWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.operationType(o.getOperationType());
            this.status(o.getStatus());
            this.timeStarted(o.getTimeStarted());
            this.timeFinished(o.getTimeFinished());
            this.policyName(o.getPolicyName());
            this.policyId(o.getPolicyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListStorageWorkRequestsRequest build() {
            ListStorageWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListStorageWorkRequestsRequest buildWithoutInvocationCallback() {
            ListStorageWorkRequestsRequest request = new ListStorageWorkRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.namespaceName = this.namespaceName;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.operationType = this.operationType;
            request.status = this.status;
            request.timeStarted = this.timeStarted;
            request.timeFinished = this.timeFinished;
            request.policyName = this.policyName;
            request.policyId = this.policyId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeAccepted("timeAccepted"),
        TimeExpires("timeExpires"),
        TimeFinished("timeFinished");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

