/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetQueryResultRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String workRequestId;
    private String page;
    private Integer limit;
    private String opcRequestId;
    private Boolean shouldIncludeColumns;
    private Boolean shouldIncludeFields;
    private OutputMode outputMode;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getShouldIncludeColumns() {
        return this.shouldIncludeColumns;
    }

    public Boolean getShouldIncludeFields() {
        return this.shouldIncludeFields;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).workRequestId(this.workRequestId).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId).shouldIncludeColumns(this.shouldIncludeColumns).shouldIncludeFields(this.shouldIncludeFields).outputMode(this.outputMode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",shouldIncludeColumns=").append(String.valueOf(this.shouldIncludeColumns));
        sb.append(",shouldIncludeFields=").append(String.valueOf(this.shouldIncludeFields));
        sb.append(",outputMode=").append(String.valueOf((Object)this.outputMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetQueryResultRequest)) {
            return false;
        }
        GetQueryResultRequest other = (GetQueryResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.shouldIncludeColumns, other.shouldIncludeColumns) && Objects.equals(this.shouldIncludeFields, other.shouldIncludeFields) && Objects.equals((Object)this.outputMode, (Object)other.outputMode);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.shouldIncludeColumns == null ? 43 : this.shouldIncludeColumns.hashCode());
        result = result * 59 + (this.shouldIncludeFields == null ? 43 : this.shouldIncludeFields.hashCode());
        result = result * 59 + (this.outputMode == null ? 43 : this.outputMode.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetQueryResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String workRequestId = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;
        private Boolean shouldIncludeColumns = null;
        private Boolean shouldIncludeFields = null;
        private OutputMode outputMode = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder shouldIncludeColumns(Boolean shouldIncludeColumns) {
            this.shouldIncludeColumns = shouldIncludeColumns;
            return this;
        }

        public Builder shouldIncludeFields(Boolean shouldIncludeFields) {
            this.shouldIncludeFields = shouldIncludeFields;
            return this;
        }

        public Builder outputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetQueryResultRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.shouldIncludeColumns(o.getShouldIncludeColumns());
            this.shouldIncludeFields(o.getShouldIncludeFields());
            this.outputMode(o.getOutputMode());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetQueryResultRequest build() {
            GetQueryResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetQueryResultRequest buildWithoutInvocationCallback() {
            GetQueryResultRequest request = new GetQueryResultRequest();
            request.namespaceName = this.namespaceName;
            request.workRequestId = this.workRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            request.shouldIncludeColumns = this.shouldIncludeColumns;
            request.shouldIncludeFields = this.shouldIncludeFields;
            request.outputMode = this.outputMode;
            return request;
        }
    }

    public static enum OutputMode implements BmcEnum
    {
        JsonRows("JSON_ROWS");

        private final String value;
        private static Map<String, OutputMode> map;

        private OutputMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OutputMode: " + key);
        }

        static {
            map = new HashMap<String, OutputMode>();
            for (OutputMode v : OutputMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

