/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLogAnalyticsLogGroupRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String logAnalyticsLogGroupId;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLogAnalyticsLogGroupId() {
        return this.logAnalyticsLogGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).logAnalyticsLogGroupId(this.logAnalyticsLogGroupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",logAnalyticsLogGroupId=").append(String.valueOf(this.logAnalyticsLogGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLogAnalyticsLogGroupRequest)) {
            return false;
        }
        GetLogAnalyticsLogGroupRequest other = (GetLogAnalyticsLogGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.logAnalyticsLogGroupId, other.logAnalyticsLogGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.logAnalyticsLogGroupId == null ? 43 : this.logAnalyticsLogGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogAnalyticsLogGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String logAnalyticsLogGroupId = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder logAnalyticsLogGroupId(String logAnalyticsLogGroupId) {
            this.logAnalyticsLogGroupId = logAnalyticsLogGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogAnalyticsLogGroupRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.logAnalyticsLogGroupId(o.getLogAnalyticsLogGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogAnalyticsLogGroupRequest build() {
            GetLogAnalyticsLogGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLogAnalyticsLogGroupRequest buildWithoutInvocationCallback() {
            GetLogAnalyticsLogGroupRequest request = new GetLogAnalyticsLogGroupRequest();
            request.namespaceName = this.namespaceName;
            request.logAnalyticsLogGroupId = this.logAnalyticsLogGroupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

