/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.AssignEncryptionKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AssignEncryptionKeyRequest
extends BmcRequest<AssignEncryptionKeyDetails> {
    private String namespaceName;
    private AssignEncryptionKeyDetails assignEncryptionKeyDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public AssignEncryptionKeyDetails getAssignEncryptionKeyDetails() {
        return this.assignEncryptionKeyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public AssignEncryptionKeyDetails getBody$() {
        return this.assignEncryptionKeyDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).assignEncryptionKeyDetails(this.assignEncryptionKeyDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",assignEncryptionKeyDetails=").append(String.valueOf((Object)this.assignEncryptionKeyDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssignEncryptionKeyRequest)) {
            return false;
        }
        AssignEncryptionKeyRequest other = (AssignEncryptionKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.assignEncryptionKeyDetails, (Object)other.assignEncryptionKeyDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.assignEncryptionKeyDetails == null ? 43 : this.assignEncryptionKeyDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AssignEncryptionKeyRequest, AssignEncryptionKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private AssignEncryptionKeyDetails assignEncryptionKeyDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder assignEncryptionKeyDetails(AssignEncryptionKeyDetails assignEncryptionKeyDetails) {
            this.assignEncryptionKeyDetails = assignEncryptionKeyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AssignEncryptionKeyRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.assignEncryptionKeyDetails(o.getAssignEncryptionKeyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AssignEncryptionKeyRequest build() {
            AssignEncryptionKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AssignEncryptionKeyDetails body) {
            this.assignEncryptionKeyDetails(body);
            return this;
        }

        public AssignEncryptionKeyRequest buildWithoutInvocationCallback() {
            AssignEncryptionKeyRequest request = new AssignEncryptionKeyRequest();
            request.namespaceName = this.namespaceName;
            request.assignEncryptionKeyDetails = this.assignEncryptionKeyDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

