/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.EventTypeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AddSourceEventTypesRequest
extends BmcRequest<EventTypeDetails> {
    private String namespaceName;
    private String sourceName;
    private EventTypeDetails addEventTypeDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public EventTypeDetails getAddEventTypeDetails() {
        return this.addEventTypeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EventTypeDetails getBody$() {
        return this.addEventTypeDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).sourceName(this.sourceName).addEventTypeDetails(this.addEventTypeDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",sourceName=").append(String.valueOf(this.sourceName));
        sb.append(",addEventTypeDetails=").append(String.valueOf((Object)this.addEventTypeDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddSourceEventTypesRequest)) {
            return false;
        }
        AddSourceEventTypesRequest other = (AddSourceEventTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals((Object)this.addEventTypeDetails, (Object)other.addEventTypeDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.addEventTypeDetails == null ? 43 : this.addEventTypeDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AddSourceEventTypesRequest, EventTypeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String sourceName = null;
        private EventTypeDetails addEventTypeDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder addEventTypeDetails(EventTypeDetails addEventTypeDetails) {
            this.addEventTypeDetails = addEventTypeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AddSourceEventTypesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.sourceName(o.getSourceName());
            this.addEventTypeDetails(o.getAddEventTypeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AddSourceEventTypesRequest build() {
            AddSourceEventTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EventTypeDetails body) {
            this.addEventTypeDetails(body);
            return this;
        }

        public AddSourceEventTypesRequest buildWithoutInvocationCallback() {
            AddSourceEventTypesRequest request = new AddSourceEventTypesRequest();
            request.namespaceName = this.namespaceName;
            request.sourceName = this.sourceName;
            request.addEventTypeDetails = this.addEventTypeDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

