/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.Indexes;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Violation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="indexes")
    private final List<Indexes> indexes;
    @JsonProperty(value="ruleDescription")
    private final String ruleDescription;
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="ruleRemediation")
    private final String ruleRemediation;
    @JsonProperty(value="ruleType")
    private final RuleType ruleType;

    @Deprecated
    @ConstructorProperties(value={"indexes", "ruleDescription", "ruleName", "ruleRemediation", "ruleType"})
    public Violation(List<Indexes> indexes, String ruleDescription, String ruleName, String ruleRemediation, RuleType ruleType) {
        this.indexes = indexes;
        this.ruleDescription = ruleDescription;
        this.ruleName = ruleName;
        this.ruleRemediation = ruleRemediation;
        this.ruleType = ruleType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Indexes> getIndexes() {
        return this.indexes;
    }

    public String getRuleDescription() {
        return this.ruleDescription;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleRemediation() {
        return this.ruleRemediation;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Violation(");
        sb.append("super=").append(super.toString());
        sb.append("indexes=").append(String.valueOf(this.indexes));
        sb.append(", ruleDescription=").append(String.valueOf(this.ruleDescription));
        sb.append(", ruleName=").append(String.valueOf(this.ruleName));
        sb.append(", ruleRemediation=").append(String.valueOf(this.ruleRemediation));
        sb.append(", ruleType=").append(String.valueOf((Object)this.ruleType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation other = (Violation)((Object)o);
        return Objects.equals(this.indexes, other.indexes) && Objects.equals(this.ruleDescription, other.ruleDescription) && Objects.equals(this.ruleName, other.ruleName) && Objects.equals(this.ruleRemediation, other.ruleRemediation) && Objects.equals((Object)this.ruleType, (Object)other.ruleType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.indexes == null ? 43 : this.indexes.hashCode());
        result = result * 59 + (this.ruleDescription == null ? 43 : this.ruleDescription.hashCode());
        result = result * 59 + (this.ruleName == null ? 43 : this.ruleName.hashCode());
        result = result * 59 + (this.ruleRemediation == null ? 43 : this.ruleRemediation.hashCode());
        result = result * 59 + (this.ruleType == null ? 43 : this.ruleType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RuleType implements BmcEnum
    {
        Warn("WARN"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleType> map;

        private RuleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleType.class);
            map = new HashMap<String, RuleType>();
            for (RuleType v : RuleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="indexes")
        private List<Indexes> indexes;
        @JsonProperty(value="ruleDescription")
        private String ruleDescription;
        @JsonProperty(value="ruleName")
        private String ruleName;
        @JsonProperty(value="ruleRemediation")
        private String ruleRemediation;
        @JsonProperty(value="ruleType")
        private RuleType ruleType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder indexes(List<Indexes> indexes) {
            this.indexes = indexes;
            this.__explicitlySet__.add("indexes");
            return this;
        }

        public Builder ruleDescription(String ruleDescription) {
            this.ruleDescription = ruleDescription;
            this.__explicitlySet__.add("ruleDescription");
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.__explicitlySet__.add("ruleName");
            return this;
        }

        public Builder ruleRemediation(String ruleRemediation) {
            this.ruleRemediation = ruleRemediation;
            this.__explicitlySet__.add("ruleRemediation");
            return this;
        }

        public Builder ruleType(RuleType ruleType) {
            this.ruleType = ruleType;
            this.__explicitlySet__.add("ruleType");
            return this;
        }

        public Violation build() {
            Violation model = new Violation(this.indexes, this.ruleDescription, this.ruleName, this.ruleRemediation, this.ruleType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Violation model) {
            if (model.wasPropertyExplicitlySet("indexes")) {
                this.indexes(model.getIndexes());
            }
            if (model.wasPropertyExplicitlySet("ruleDescription")) {
                this.ruleDescription(model.getRuleDescription());
            }
            if (model.wasPropertyExplicitlySet("ruleName")) {
                this.ruleName(model.getRuleName());
            }
            if (model.wasPropertyExplicitlySet("ruleRemediation")) {
                this.ruleRemediation(model.getRuleRemediation());
            }
            if (model.wasPropertyExplicitlySet("ruleType")) {
                this.ruleType(model.getRuleType());
            }
            return this;
        }
    }
}

