/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UsageStatusItem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="isMultiValued")
    private final Boolean isMultiValued;
    @JsonProperty(value="currentUsage")
    private final Long currentUsage;
    @JsonProperty(value="maxAvailable")
    private final Integer maxAvailable;

    @Deprecated
    @ConstructorProperties(value={"dataType", "isMultiValued", "currentUsage", "maxAvailable"})
    public UsageStatusItem(String dataType, Boolean isMultiValued, Long currentUsage, Integer maxAvailable) {
        this.dataType = dataType;
        this.isMultiValued = isMultiValued;
        this.currentUsage = currentUsage;
        this.maxAvailable = maxAvailable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataType() {
        return this.dataType;
    }

    public Boolean getIsMultiValued() {
        return this.isMultiValued;
    }

    public Long getCurrentUsage() {
        return this.currentUsage;
    }

    public Integer getMaxAvailable() {
        return this.maxAvailable;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UsageStatusItem(");
        sb.append("super=").append(super.toString());
        sb.append("dataType=").append(String.valueOf(this.dataType));
        sb.append(", isMultiValued=").append(String.valueOf(this.isMultiValued));
        sb.append(", currentUsage=").append(String.valueOf(this.currentUsage));
        sb.append(", maxAvailable=").append(String.valueOf(this.maxAvailable));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsageStatusItem)) {
            return false;
        }
        UsageStatusItem other = (UsageStatusItem)((Object)o);
        return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.isMultiValued, other.isMultiValued) && Objects.equals(this.currentUsage, other.currentUsage) && Objects.equals(this.maxAvailable, other.maxAvailable) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.isMultiValued == null ? 43 : this.isMultiValued.hashCode());
        result = result * 59 + (this.currentUsage == null ? 43 : this.currentUsage.hashCode());
        result = result * 59 + (this.maxAvailable == null ? 43 : this.maxAvailable.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="isMultiValued")
        private Boolean isMultiValued;
        @JsonProperty(value="currentUsage")
        private Long currentUsage;
        @JsonProperty(value="maxAvailable")
        private Integer maxAvailable;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder isMultiValued(Boolean isMultiValued) {
            this.isMultiValued = isMultiValued;
            this.__explicitlySet__.add("isMultiValued");
            return this;
        }

        public Builder currentUsage(Long currentUsage) {
            this.currentUsage = currentUsage;
            this.__explicitlySet__.add("currentUsage");
            return this;
        }

        public Builder maxAvailable(Integer maxAvailable) {
            this.maxAvailable = maxAvailable;
            this.__explicitlySet__.add("maxAvailable");
            return this;
        }

        public UsageStatusItem build() {
            UsageStatusItem model = new UsageStatusItem(this.dataType, this.isMultiValued, this.currentUsage, this.maxAvailable);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UsageStatusItem model) {
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("isMultiValued")) {
                this.isMultiValued(model.getIsMultiValued());
            }
            if (model.wasPropertyExplicitlySet("currentUsage")) {
                this.currentUsage(model.getCurrentUsage());
            }
            if (model.wasPropertyExplicitlySet("maxAvailable")) {
                this.maxAvailable(model.getMaxAvailable());
            }
            return this;
        }
    }
}

