/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.FunctionField;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class StatsCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="groupByFields")
    private final List<AbstractField> groupByFields;
    @JsonProperty(value="functions")
    private final List<FunctionField> functions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StatsCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, List<AbstractField> groupByFields, List<FunctionField> functions) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.groupByFields = groupByFields;
        this.functions = functions;
    }

    public List<AbstractField> getGroupByFields() {
        return this.groupByFields;
    }

    public List<FunctionField> getFunctions() {
        return this.functions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatsCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", groupByFields=").append(String.valueOf(this.groupByFields));
        sb.append(", functions=").append(String.valueOf(this.functions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatsCommandDescriptor)) {
            return false;
        }
        StatsCommandDescriptor other = (StatsCommandDescriptor)((Object)o);
        return Objects.equals(this.groupByFields, other.groupByFields) && Objects.equals(this.functions, other.functions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.groupByFields == null ? 43 : this.groupByFields.hashCode());
        result = result * 59 + (this.functions == null ? 43 : this.functions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="groupByFields")
        private List<AbstractField> groupByFields;
        @JsonProperty(value="functions")
        private List<FunctionField> functions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder groupByFields(List<AbstractField> groupByFields) {
            this.groupByFields = groupByFields;
            this.__explicitlySet__.add("groupByFields");
            return this;
        }

        public Builder functions(List<FunctionField> functions) {
            this.functions = functions;
            this.__explicitlySet__.add("functions");
            return this;
        }

        public StatsCommandDescriptor build() {
            StatsCommandDescriptor model = new StatsCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.groupByFields, this.functions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatsCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("groupByFields")) {
                this.groupByFields(model.getGroupByFields());
            }
            if (model.wasPropertyExplicitlySet("functions")) {
                this.functions(model.getFunctions());
            }
            return this;
        }
    }
}

