/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.Action;
import com.oracle.bmc.loganalytics.model.Schedule;
import com.oracle.bmc.loganalytics.model.StandardTask;
import com.oracle.bmc.loganalytics.model.TaskType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind", defaultImpl=ScheduledTask.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=StandardTask.class, name="STANDARD")})
@JsonFilter(value="explicitlySetFilter")
public class ScheduledTask
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="schedules")
    private final List<Schedule> schedules;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="taskStatus")
    private final TaskStatus taskStatus;
    @JsonProperty(value="pauseReason")
    private final PauseReason pauseReason;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;
    @JsonProperty(value="numOccurrences")
    private final Long numOccurrences;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeOfNextExecution")
    private final Date timeOfNextExecution;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "taskType", "schedules", "action", "taskStatus", "pauseReason", "workRequestId", "numOccurrences", "compartmentId", "timeCreated", "timeUpdated", "timeOfNextExecution", "lifecycleState", "freeformTags", "definedTags"})
    protected ScheduledTask(String id, String displayName, TaskType taskType, List<Schedule> schedules, Action action, TaskStatus taskStatus, PauseReason pauseReason, String workRequestId, Long numOccurrences, String compartmentId, Date timeCreated, Date timeUpdated, Date timeOfNextExecution, LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.displayName = displayName;
        this.taskType = taskType;
        this.schedules = schedules;
        this.action = action;
        this.taskStatus = taskStatus;
        this.pauseReason = pauseReason;
        this.workRequestId = workRequestId;
        this.numOccurrences = numOccurrences;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeOfNextExecution = timeOfNextExecution;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public Action getAction() {
        return this.action;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public PauseReason getPauseReason() {
        return this.pauseReason;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public Long getNumOccurrences() {
        return this.numOccurrences;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeOfNextExecution() {
        return this.timeOfNextExecution;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledTask(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(", schedules=").append(String.valueOf(this.schedules));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", taskStatus=").append(String.valueOf((Object)this.taskStatus));
        sb.append(", pauseReason=").append(String.valueOf((Object)this.pauseReason));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(", numOccurrences=").append(String.valueOf(this.numOccurrences));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeOfNextExecution=").append(String.valueOf(this.timeOfNextExecution));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledTask)) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals(this.schedules, other.schedules) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.taskStatus, (Object)other.taskStatus) && Objects.equals((Object)this.pauseReason, (Object)other.pauseReason) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.numOccurrences, other.numOccurrences) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeOfNextExecution, other.timeOfNextExecution) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.schedules == null ? 43 : this.schedules.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.taskStatus == null ? 43 : this.taskStatus.hashCode());
        result = result * 59 + (this.pauseReason == null ? 43 : this.pauseReason.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.numOccurrences == null ? 43 : this.numOccurrences.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeOfNextExecution == null ? 43 : this.timeOfNextExecution.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Kind implements BmcEnum
    {
        Acceleration("ACCELERATION"),
        Standard("STANDARD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Kind> map;

        private Kind(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Kind create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Kind', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Kind.class);
            map = new HashMap<String, Kind>();
            for (Kind v : Kind.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PauseReason implements BmcEnum
    {
        MetricExtractionNotValid("METRIC_EXTRACTION_NOT_VALID"),
        SavedSearchNotValid("SAVED_SEARCH_NOT_VALID"),
        SavedSearchNotFound("SAVED_SEARCH_NOT_FOUND"),
        QueryStringNotValid("QUERY_STRING_NOT_VALID"),
        UserAction("USER_ACTION"),
        TenancyLifecycle("TENANCY_LIFECYCLE"),
        PurgeResourceNotFound("PURGE_RESOURCE_NOT_FOUND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PauseReason> map;

        private PauseReason(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PauseReason create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PauseReason', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PauseReason.class);
            map = new HashMap<String, PauseReason>();
            for (PauseReason v : PauseReason.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TaskStatus implements BmcEnum
    {
        Ready("READY"),
        Paused("PAUSED"),
        Completed("COMPLETED"),
        Blocked("BLOCKED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskStatus> map;

        private TaskStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskStatus.class);
            map = new HashMap<String, TaskStatus>();
            for (TaskStatus v : TaskStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

