/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResultColumn
extends ExplicitlySetBmcModel {
    @JsonProperty(value="internalName")
    private final String internalName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="valueType")
    private final ValueType valueType;

    @Deprecated
    @ConstructorProperties(value={"internalName", "displayName", "valueType"})
    public ResultColumn(String internalName, String displayName, ValueType valueType) {
        this.internalName = internalName;
        this.displayName = displayName;
        this.valueType = valueType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultColumn(");
        sb.append("super=").append(super.toString());
        sb.append("internalName=").append(String.valueOf(this.internalName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", valueType=").append(String.valueOf((Object)this.valueType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultColumn)) {
            return false;
        }
        ResultColumn other = (ResultColumn)((Object)o);
        return Objects.equals(this.internalName, other.internalName) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.valueType, (Object)other.valueType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.internalName == null ? 43 : this.internalName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.valueType == null ? 43 : this.valueType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public ResultColumn build() {
            ResultColumn model = new ResultColumn(this.internalName, this.displayName, this.valueType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResultColumn model) {
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            return this;
        }
    }
}

