/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.JobMode;
import com.oracle.bmc.loganalytics.model.QueryOperationType;
import com.oracle.bmc.loganalytics.model.ScopeFilter;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.TimeRange;
import com.oracle.bmc.loganalytics.model.WorkRequestStatus;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryWorkRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;
    @JsonProperty(value="status")
    private final WorkRequestStatus status;
    @JsonProperty(value="operationType")
    private final QueryOperationType operationType;
    @JsonProperty(value="mode")
    private final JobMode mode;
    @JsonProperty(value="timeBackgroundAt")
    private final Date timeBackgroundAt;
    @JsonProperty(value="timeFilter")
    private final TimeRange timeFilter;
    @JsonProperty(value="scopeFilters")
    private final List<ScopeFilter> scopeFilters;
    @JsonProperty(value="subSystem")
    private final SubSystemName subSystem;
    @JsonProperty(value="displayQueryString")
    private final String displayQueryString;
    @JsonProperty(value="internalQueryString")
    private final String internalQueryString;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "timeStarted", "timeAccepted", "timeFinished", "timeExpires", "percentComplete", "status", "operationType", "mode", "timeBackgroundAt", "timeFilter", "scopeFilters", "subSystem", "displayQueryString", "internalQueryString"})
    public QueryWorkRequest(String id, String compartmentId, Date timeStarted, Date timeAccepted, Date timeFinished, Date timeExpires, Integer percentComplete, WorkRequestStatus status, QueryOperationType operationType, JobMode mode, Date timeBackgroundAt, TimeRange timeFilter, List<ScopeFilter> scopeFilters, SubSystemName subSystem, String displayQueryString, String internalQueryString) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.timeStarted = timeStarted;
        this.timeAccepted = timeAccepted;
        this.timeFinished = timeFinished;
        this.timeExpires = timeExpires;
        this.percentComplete = percentComplete;
        this.status = status;
        this.operationType = operationType;
        this.mode = mode;
        this.timeBackgroundAt = timeBackgroundAt;
        this.timeFilter = timeFilter;
        this.scopeFilters = scopeFilters;
        this.subSystem = subSystem;
        this.displayQueryString = displayQueryString;
        this.internalQueryString = internalQueryString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public WorkRequestStatus getStatus() {
        return this.status;
    }

    public QueryOperationType getOperationType() {
        return this.operationType;
    }

    public JobMode getMode() {
        return this.mode;
    }

    public Date getTimeBackgroundAt() {
        return this.timeBackgroundAt;
    }

    public TimeRange getTimeFilter() {
        return this.timeFilter;
    }

    public List<ScopeFilter> getScopeFilters() {
        return this.scopeFilters;
    }

    public SubSystemName getSubSystem() {
        return this.subSystem;
    }

    public String getDisplayQueryString() {
        return this.displayQueryString;
    }

    public String getInternalQueryString() {
        return this.internalQueryString;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryWorkRequest(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", mode=").append(String.valueOf((Object)this.mode));
        sb.append(", timeBackgroundAt=").append(String.valueOf(this.timeBackgroundAt));
        sb.append(", timeFilter=").append(String.valueOf((Object)this.timeFilter));
        sb.append(", scopeFilters=").append(String.valueOf(this.scopeFilters));
        sb.append(", subSystem=").append(String.valueOf((Object)this.subSystem));
        sb.append(", displayQueryString=").append(String.valueOf(this.displayQueryString));
        sb.append(", internalQueryString=").append(String.valueOf(this.internalQueryString));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryWorkRequest)) {
            return false;
        }
        QueryWorkRequest other = (QueryWorkRequest)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.timeExpires, other.timeExpires) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.timeBackgroundAt, other.timeBackgroundAt) && Objects.equals((Object)this.timeFilter, (Object)other.timeFilter) && Objects.equals(this.scopeFilters, other.scopeFilters) && Objects.equals((Object)this.subSystem, (Object)other.subSystem) && Objects.equals(this.displayQueryString, other.displayQueryString) && Objects.equals(this.internalQueryString, other.internalQueryString) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + (this.timeBackgroundAt == null ? 43 : this.timeBackgroundAt.hashCode());
        result = result * 59 + (this.timeFilter == null ? 43 : this.timeFilter.hashCode());
        result = result * 59 + (this.scopeFilters == null ? 43 : this.scopeFilters.hashCode());
        result = result * 59 + (this.subSystem == null ? 43 : this.subSystem.hashCode());
        result = result * 59 + (this.displayQueryString == null ? 43 : this.displayQueryString.hashCode());
        result = result * 59 + (this.internalQueryString == null ? 43 : this.internalQueryString.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonProperty(value="status")
        private WorkRequestStatus status;
        @JsonProperty(value="operationType")
        private QueryOperationType operationType;
        @JsonProperty(value="mode")
        private JobMode mode;
        @JsonProperty(value="timeBackgroundAt")
        private Date timeBackgroundAt;
        @JsonProperty(value="timeFilter")
        private TimeRange timeFilter;
        @JsonProperty(value="scopeFilters")
        private List<ScopeFilter> scopeFilters;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder status(WorkRequestStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder operationType(QueryOperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder mode(JobMode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder timeBackgroundAt(Date timeBackgroundAt) {
            this.timeBackgroundAt = timeBackgroundAt;
            this.__explicitlySet__.add("timeBackgroundAt");
            return this;
        }

        public Builder timeFilter(TimeRange timeFilter) {
            this.timeFilter = timeFilter;
            this.__explicitlySet__.add("timeFilter");
            return this;
        }

        public Builder scopeFilters(List<ScopeFilter> scopeFilters) {
            this.scopeFilters = scopeFilters;
            this.__explicitlySet__.add("scopeFilters");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public QueryWorkRequest build() {
            QueryWorkRequest model = new QueryWorkRequest(this.id, this.compartmentId, this.timeStarted, this.timeAccepted, this.timeFinished, this.timeExpires, this.percentComplete, this.status, this.operationType, this.mode, this.timeBackgroundAt, this.timeFilter, this.scopeFilters, this.subSystem, this.displayQueryString, this.internalQueryString);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryWorkRequest model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("timeBackgroundAt")) {
                this.timeBackgroundAt(model.getTimeBackgroundAt());
            }
            if (model.wasPropertyExplicitlySet("timeFilter")) {
                this.timeFilter(model.getTimeFilter());
            }
            if (model.wasPropertyExplicitlySet("scopeFilters")) {
                this.scopeFilters(model.getScopeFilters());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            return this;
        }
    }
}

