/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.Action;
import com.oracle.bmc.loganalytics.model.StorageDataType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class PurgeAction
extends Action {
    @JsonProperty(value="queryString")
    private final String queryString;
    @JsonProperty(value="dataType")
    private final StorageDataType dataType;
    @JsonProperty(value="purgeDuration")
    private final String purgeDuration;
    @JsonProperty(value="purgeCompartmentId")
    private final String purgeCompartmentId;
    @JsonProperty(value="compartmentIdInSubtree")
    private final Boolean compartmentIdInSubtree;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PurgeAction(String queryString, StorageDataType dataType, String purgeDuration, String purgeCompartmentId, Boolean compartmentIdInSubtree) {
        this.queryString = queryString;
        this.dataType = dataType;
        this.purgeDuration = purgeDuration;
        this.purgeCompartmentId = purgeCompartmentId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public StorageDataType getDataType() {
        return this.dataType;
    }

    public String getPurgeDuration() {
        return this.purgeDuration;
    }

    public String getPurgeCompartmentId() {
        return this.purgeCompartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PurgeAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", queryString=").append(String.valueOf(this.queryString));
        sb.append(", dataType=").append(String.valueOf((Object)this.dataType));
        sb.append(", purgeDuration=").append(String.valueOf(this.purgeDuration));
        sb.append(", purgeCompartmentId=").append(String.valueOf(this.purgeCompartmentId));
        sb.append(", compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurgeAction)) {
            return false;
        }
        PurgeAction other = (PurgeAction)((Object)o);
        return Objects.equals(this.queryString, other.queryString) && Objects.equals((Object)this.dataType, (Object)other.dataType) && Objects.equals(this.purgeDuration, other.purgeDuration) && Objects.equals(this.purgeCompartmentId, other.purgeCompartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queryString == null ? 43 : this.queryString.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.purgeDuration == null ? 43 : this.purgeDuration.hashCode());
        result = result * 59 + (this.purgeCompartmentId == null ? 43 : this.purgeCompartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="queryString")
        private String queryString;
        @JsonProperty(value="dataType")
        private StorageDataType dataType;
        @JsonProperty(value="purgeDuration")
        private String purgeDuration;
        @JsonProperty(value="purgeCompartmentId")
        private String purgeCompartmentId;
        @JsonProperty(value="compartmentIdInSubtree")
        private Boolean compartmentIdInSubtree;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            this.__explicitlySet__.add("queryString");
            return this;
        }

        public Builder dataType(StorageDataType dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder purgeDuration(String purgeDuration) {
            this.purgeDuration = purgeDuration;
            this.__explicitlySet__.add("purgeDuration");
            return this;
        }

        public Builder purgeCompartmentId(String purgeCompartmentId) {
            this.purgeCompartmentId = purgeCompartmentId;
            this.__explicitlySet__.add("purgeCompartmentId");
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            this.__explicitlySet__.add("compartmentIdInSubtree");
            return this;
        }

        public PurgeAction build() {
            PurgeAction model = new PurgeAction(this.queryString, this.dataType, this.purgeDuration, this.purgeCompartmentId, this.compartmentIdInSubtree);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PurgeAction model) {
            if (model.wasPropertyExplicitlySet("queryString")) {
                this.queryString(model.getQueryString());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("purgeDuration")) {
                this.purgeDuration(model.getPurgeDuration());
            }
            if (model.wasPropertyExplicitlySet("purgeCompartmentId")) {
                this.purgeCompartmentId(model.getPurgeCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("compartmentIdInSubtree")) {
                this.compartmentIdInSubtree(model.getCompartmentIdInSubtree());
            }
            return this;
        }
    }
}

