/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.ParsedField;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ParsedContent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldNames")
    private final List<String> fieldNames;
    @JsonProperty(value="fieldDisplayNames")
    private final List<String> fieldDisplayNames;
    @JsonProperty(value="parsedFieldValues")
    private final List<ParsedField> parsedFieldValues;
    @JsonProperty(value="logContent")
    private final String logContent;
    @JsonProperty(value="sampleSize")
    private final Integer sampleSize;
    @JsonProperty(value="matchStatus")
    private final String matchStatus;

    @Deprecated
    @ConstructorProperties(value={"fieldNames", "fieldDisplayNames", "parsedFieldValues", "logContent", "sampleSize", "matchStatus"})
    public ParsedContent(List<String> fieldNames, List<String> fieldDisplayNames, List<ParsedField> parsedFieldValues, String logContent, Integer sampleSize, String matchStatus) {
        this.fieldNames = fieldNames;
        this.fieldDisplayNames = fieldDisplayNames;
        this.parsedFieldValues = parsedFieldValues;
        this.logContent = logContent;
        this.sampleSize = sampleSize;
        this.matchStatus = matchStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<String> getFieldDisplayNames() {
        return this.fieldDisplayNames;
    }

    public List<ParsedField> getParsedFieldValues() {
        return this.parsedFieldValues;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public String getMatchStatus() {
        return this.matchStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParsedContent(");
        sb.append("super=").append(super.toString());
        sb.append("fieldNames=").append(String.valueOf(this.fieldNames));
        sb.append(", fieldDisplayNames=").append(String.valueOf(this.fieldDisplayNames));
        sb.append(", parsedFieldValues=").append(String.valueOf(this.parsedFieldValues));
        sb.append(", logContent=").append(String.valueOf(this.logContent));
        sb.append(", sampleSize=").append(String.valueOf(this.sampleSize));
        sb.append(", matchStatus=").append(String.valueOf(this.matchStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsedContent)) {
            return false;
        }
        ParsedContent other = (ParsedContent)((Object)o);
        return Objects.equals(this.fieldNames, other.fieldNames) && Objects.equals(this.fieldDisplayNames, other.fieldDisplayNames) && Objects.equals(this.parsedFieldValues, other.parsedFieldValues) && Objects.equals(this.logContent, other.logContent) && Objects.equals(this.sampleSize, other.sampleSize) && Objects.equals(this.matchStatus, other.matchStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldNames == null ? 43 : this.fieldNames.hashCode());
        result = result * 59 + (this.fieldDisplayNames == null ? 43 : this.fieldDisplayNames.hashCode());
        result = result * 59 + (this.parsedFieldValues == null ? 43 : this.parsedFieldValues.hashCode());
        result = result * 59 + (this.logContent == null ? 43 : this.logContent.hashCode());
        result = result * 59 + (this.sampleSize == null ? 43 : this.sampleSize.hashCode());
        result = result * 59 + (this.matchStatus == null ? 43 : this.matchStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldNames")
        private List<String> fieldNames;
        @JsonProperty(value="fieldDisplayNames")
        private List<String> fieldDisplayNames;
        @JsonProperty(value="parsedFieldValues")
        private List<ParsedField> parsedFieldValues;
        @JsonProperty(value="logContent")
        private String logContent;
        @JsonProperty(value="sampleSize")
        private Integer sampleSize;
        @JsonProperty(value="matchStatus")
        private String matchStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldNames(List<String> fieldNames) {
            this.fieldNames = fieldNames;
            this.__explicitlySet__.add("fieldNames");
            return this;
        }

        public Builder fieldDisplayNames(List<String> fieldDisplayNames) {
            this.fieldDisplayNames = fieldDisplayNames;
            this.__explicitlySet__.add("fieldDisplayNames");
            return this;
        }

        public Builder parsedFieldValues(List<ParsedField> parsedFieldValues) {
            this.parsedFieldValues = parsedFieldValues;
            this.__explicitlySet__.add("parsedFieldValues");
            return this;
        }

        public Builder logContent(String logContent) {
            this.logContent = logContent;
            this.__explicitlySet__.add("logContent");
            return this;
        }

        public Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            this.__explicitlySet__.add("sampleSize");
            return this;
        }

        public Builder matchStatus(String matchStatus) {
            this.matchStatus = matchStatus;
            this.__explicitlySet__.add("matchStatus");
            return this;
        }

        public ParsedContent build() {
            ParsedContent model = new ParsedContent(this.fieldNames, this.fieldDisplayNames, this.parsedFieldValues, this.logContent, this.sampleSize, this.matchStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ParsedContent model) {
            if (model.wasPropertyExplicitlySet("fieldNames")) {
                this.fieldNames(model.getFieldNames());
            }
            if (model.wasPropertyExplicitlySet("fieldDisplayNames")) {
                this.fieldDisplayNames(model.getFieldDisplayNames());
            }
            if (model.wasPropertyExplicitlySet("parsedFieldValues")) {
                this.parsedFieldValues(model.getParsedFieldValues());
            }
            if (model.wasPropertyExplicitlySet("logContent")) {
                this.logContent(model.getLogContent());
            }
            if (model.wasPropertyExplicitlySet("sampleSize")) {
                this.sampleSize(model.getSampleSize());
            }
            if (model.wasPropertyExplicitlySet("matchStatus")) {
                this.matchStatus(model.getMatchStatus());
            }
            return this;
        }
    }
}

