/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NamespaceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isOnboarded")
    private final Boolean isOnboarded;
    @JsonProperty(value="isLogSetEnabled")
    private final Boolean isLogSetEnabled;
    @JsonProperty(value="isDataEverIngested")
    private final Boolean isDataEverIngested;

    @Deprecated
    @ConstructorProperties(value={"namespaceName", "compartmentId", "isOnboarded", "isLogSetEnabled", "isDataEverIngested"})
    public NamespaceSummary(String namespaceName, String compartmentId, Boolean isOnboarded, Boolean isLogSetEnabled, Boolean isDataEverIngested) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.isOnboarded = isOnboarded;
        this.isLogSetEnabled = isLogSetEnabled;
        this.isDataEverIngested = isDataEverIngested;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsOnboarded() {
        return this.isOnboarded;
    }

    public Boolean getIsLogSetEnabled() {
        return this.isLogSetEnabled;
    }

    public Boolean getIsDataEverIngested() {
        return this.isDataEverIngested;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NamespaceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isOnboarded=").append(String.valueOf(this.isOnboarded));
        sb.append(", isLogSetEnabled=").append(String.valueOf(this.isLogSetEnabled));
        sb.append(", isDataEverIngested=").append(String.valueOf(this.isDataEverIngested));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespaceSummary)) {
            return false;
        }
        NamespaceSummary other = (NamespaceSummary)((Object)o);
        return Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isOnboarded, other.isOnboarded) && Objects.equals(this.isLogSetEnabled, other.isLogSetEnabled) && Objects.equals(this.isDataEverIngested, other.isDataEverIngested) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isOnboarded == null ? 43 : this.isOnboarded.hashCode());
        result = result * 59 + (this.isLogSetEnabled == null ? 43 : this.isLogSetEnabled.hashCode());
        result = result * 59 + (this.isDataEverIngested == null ? 43 : this.isDataEverIngested.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isOnboarded")
        private Boolean isOnboarded;
        @JsonProperty(value="isLogSetEnabled")
        private Boolean isLogSetEnabled;
        @JsonProperty(value="isDataEverIngested")
        private Boolean isDataEverIngested;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isOnboarded(Boolean isOnboarded) {
            this.isOnboarded = isOnboarded;
            this.__explicitlySet__.add("isOnboarded");
            return this;
        }

        public Builder isLogSetEnabled(Boolean isLogSetEnabled) {
            this.isLogSetEnabled = isLogSetEnabled;
            this.__explicitlySet__.add("isLogSetEnabled");
            return this;
        }

        public Builder isDataEverIngested(Boolean isDataEverIngested) {
            this.isDataEverIngested = isDataEverIngested;
            this.__explicitlySet__.add("isDataEverIngested");
            return this;
        }

        public NamespaceSummary build() {
            NamespaceSummary model = new NamespaceSummary(this.namespaceName, this.compartmentId, this.isOnboarded, this.isLogSetEnabled, this.isDataEverIngested);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NamespaceSummary model) {
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isOnboarded")) {
                this.isOnboarded(model.getIsOnboarded());
            }
            if (model.wasPropertyExplicitlySet("isLogSetEnabled")) {
                this.isLogSetEnabled(model.getIsLogSetEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDataEverIngested")) {
                this.isDataEverIngested(model.getIsDataEverIngested());
            }
            return this;
        }
    }
}

