/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSource;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourcePattern;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsPatternFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pattern")
    private final LogAnalyticsSourcePattern pattern;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="isInUse")
    private final Boolean isInUse;
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="patternId")
    private final Long patternId;
    @JsonProperty(value="sourceId")
    private final Long sourceId;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="source")
    private final LogAnalyticsSource source;

    @Deprecated
    @ConstructorProperties(value={"pattern", "agentVersion", "isInUse", "operatingSystem", "patternId", "sourceId", "version", "source"})
    public LogAnalyticsPatternFilter(LogAnalyticsSourcePattern pattern, String agentVersion, Boolean isInUse, String operatingSystem, Long patternId, Long sourceId, String version, LogAnalyticsSource source) {
        this.pattern = pattern;
        this.agentVersion = agentVersion;
        this.isInUse = isInUse;
        this.operatingSystem = operatingSystem;
        this.patternId = patternId;
        this.sourceId = sourceId;
        this.version = version;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LogAnalyticsSourcePattern getPattern() {
        return this.pattern;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public Boolean getIsInUse() {
        return this.isInUse;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public Long getPatternId() {
        return this.patternId;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public String getVersion() {
        return this.version;
    }

    public LogAnalyticsSource getSource() {
        return this.source;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsPatternFilter(");
        sb.append("super=").append(super.toString());
        sb.append("pattern=").append(String.valueOf((Object)this.pattern));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", isInUse=").append(String.valueOf(this.isInUse));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", patternId=").append(String.valueOf(this.patternId));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsPatternFilter)) {
            return false;
        }
        LogAnalyticsPatternFilter other = (LogAnalyticsPatternFilter)((Object)o);
        return Objects.equals((Object)this.pattern, (Object)other.pattern) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.isInUse, other.isInUse) && Objects.equals(this.operatingSystem, other.operatingSystem) && Objects.equals(this.patternId, other.patternId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.source, (Object)other.source) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pattern == null ? 43 : this.pattern.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.isInUse == null ? 43 : this.isInUse.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.patternId == null ? 43 : this.patternId.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pattern")
        private LogAnalyticsSourcePattern pattern;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="isInUse")
        private Boolean isInUse;
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="patternId")
        private Long patternId;
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="source")
        private LogAnalyticsSource source;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pattern(LogAnalyticsSourcePattern pattern) {
            this.pattern = pattern;
            this.__explicitlySet__.add("pattern");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder isInUse(Boolean isInUse) {
            this.isInUse = isInUse;
            this.__explicitlySet__.add("isInUse");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder patternId(Long patternId) {
            this.patternId = patternId;
            this.__explicitlySet__.add("patternId");
            return this;
        }

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder source(LogAnalyticsSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public LogAnalyticsPatternFilter build() {
            LogAnalyticsPatternFilter model = new LogAnalyticsPatternFilter(this.pattern, this.agentVersion, this.isInUse, this.operatingSystem, this.patternId, this.sourceId, this.version, this.source);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsPatternFilter model) {
            if (model.wasPropertyExplicitlySet("pattern")) {
                this.pattern(model.getPattern());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("isInUse")) {
                this.isInUse(model.getIsInUse());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("patternId")) {
                this.patternId(model.getPatternId());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            return this;
        }
    }
}

